/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit.act;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.act.ParticipationCollectionEditor;
import org.openvpms.web.component.im.edit.act.ParticipationEditor;
import org.openvpms.web.component.property.ModifiableListener;

public class ParticipationMonitor<T extends Entity> {
    private final ModifiableListener modifiableListener;
    private final ParticipationCollectionEditor collectionEditor;
    private Consumer<T> listener;
    private Reference entity;

    ParticipationMonitor(ParticipationCollectionEditor collectionEditor, Consumer<T> listener) {
        if (collectionEditor.getCollection().getMaxCardinality() > 1) {
            throw new IllegalStateException("Cannot monitor collections with cardinality > 1");
        }
        this.collectionEditor = collectionEditor;
        this.modifiableListener = modifiable -> this.onChanged();
        this.collectionEditor.addModifiableListener(this.modifiableListener);
        this.listener = listener;
        T current = this.getEntity();
        this.entity = current != null ? current.getObjectReference() : null;
    }

    public void dispose() {
        if (this.collectionEditor != null) {
            this.collectionEditor.removeModifiableListener(this.modifiableListener);
            this.listener = null;
        }
    }

    private void onChanged() {
        Reference currentRef;
        T current = this.getEntity();
        Reference reference = currentRef = current != null ? current.getObjectReference() : null;
        if (!Objects.equals(this.entity, currentRef)) {
            this.entity = currentRef;
            this.listener.accept(current);
        }
    }

    private T getEntity() {
        ParticipationEditor<T> editor = this.getEditor();
        return editor != null ? (T)editor.getEntity() : null;
    }

    private ParticipationEditor<T> getEditor() {
        Collection<IMObject> objects;
        IMObjectEditor result = this.collectionEditor.getCurrentEditor();
        if (result == null && !(objects = this.collectionEditor.getCurrentObjects()).isEmpty()) {
            result = this.collectionEditor.getEditor(objects.iterator().next());
        }
        return result instanceof ParticipationEditor ? (ParticipationEditor)result : null;
    }
}

