/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit.act;

import java.math.BigDecimal;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.rules.practice.LocationRules;
import org.openvpms.archetype.rules.product.ProductPriceRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.product.ProductPrice;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.im.clinician.ClinicianParticipationEditor;
import org.openvpms.web.component.im.edit.act.AbstractActEditor;
import org.openvpms.web.component.im.edit.act.ParticipationEditor;
import org.openvpms.web.component.im.edit.act.ProductListener;
import org.openvpms.web.component.im.edit.act.TemplateProduct;
import org.openvpms.web.component.im.layout.AbstractLayoutStrategy;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.patient.PatientParticipationEditor;
import org.openvpms.web.component.im.product.ProductParticipationEditor;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.system.ServiceHelper;

public abstract class ActItemEditor
extends AbstractActEditor {
    public static final String PATIENT = "patient";
    public static final String PRODUCT = "product";
    public static final String TEMPLATE = "template";
    public static final String QUANTITY = "quantity";
    public static final String CLINICIAN = "clinician";
    public static final String FIXED_PRICE = "fixedPrice";
    public static final String UNIT_PRICE = "unitPrice";
    public static final String DISCOUNT = "discount";
    public static final String LOCATION = "location";
    protected static final String PRINT = "print";
    private final ProductPriceRules rules = ServiceHelper.getBean(ProductPriceRules.class);
    private final Party location;
    private final Lookup pricingGroup;
    private final ModifiableListener productListener;
    private ArchetypeNodes nodes;
    private ProductListener listener;
    private boolean currentTemplate;
    private static final String TEMPLATE_GROUP = "group";

    public ActItemEditor(Act act, Act parent, LayoutContext context) {
        super(act, (IMObject)parent, context);
        if (act.isNew() && parent != null) {
            act.setActivityStartTime(parent.getActivityStartTime());
        }
        this.location = this.getLocation(parent, context);
        this.pricingGroup = this.getPricingGroup(this.location);
        this.productListener = modifiable -> this.productModified();
    }

    public Reference getCustomerRef() {
        Act act = (Act)this.getParent();
        if (act != null) {
            IMObjectBean bean = this.getBean((IMObject)act);
            return bean.getTargetRef("customer");
        }
        return null;
    }

    public Party getCustomer() {
        return (Party)this.getObject(this.getCustomerRef());
    }

    public Reference getProductRef() {
        return this.getParticipantRef(PRODUCT);
    }

    public Product getProduct() {
        return (Product)this.getObject(this.getProductRef());
    }

    public void setProduct(Product product) {
        this.setProductRef(product != null ? product.getObjectReference() : null);
    }

    public void setProductRef(Reference product) {
        this.setParticipant(PRODUCT, product);
    }

    public void setProduct(Reference product, Reference template, int group) {
        this.setTemplateRef(template, group);
        this.setProductRef(product);
    }

    public void setProduct(TemplateProduct product, Product template, int group) {
        this.setTemplate(template, group);
        if (product != null) {
            this.setQuantity(BigDecimal.ZERO);
            this.setProduct(product.getProduct());
            if (MathRules.isZero((BigDecimal)this.getQuantity())) {
                this.setQuantity(product.getHighQuantity());
            }
            if (product.getZeroPrice()) {
                this.setFixedPrice(BigDecimal.ZERO);
                this.setUnitPrice(BigDecimal.ZERO);
                this.setDiscount(BigDecimal.ZERO);
            }
        } else {
            this.setProduct(null);
        }
    }

    public Product getTemplate() {
        return (Product)this.getObject(this.getTemplateRef());
    }

    public Reference getTemplateRef() {
        return this.getParticipantRef(TEMPLATE);
    }

    public int getTemplateGroup() {
        int result = -1;
        CollectionProperty property = this.getCollectionProperty(TEMPLATE);
        if (property != null && !property.isEmpty()) {
            IMObject object = (IMObject)property.getValues().get(0);
            IMObjectBean bean = this.getBean(object);
            result = bean.getInt(TEMPLATE_GROUP, -1);
        }
        return result;
    }

    public Party getPatient() {
        return (Party)this.getObject(this.getPatientRef());
    }

    public Reference getPatientRef() {
        return this.getParticipantRef(PATIENT);
    }

    public void setPatient(Party patient) {
        this.setPatientRef(patient != null ? patient.getObjectReference() : null);
    }

    public void setPatientRef(Reference patient) {
        this.setParticipant(PATIENT, patient);
    }

    public User getClinician() {
        return (User)this.getObject(this.getClinicianRef());
    }

    public Reference getClinicianRef() {
        return this.getParticipantRef(CLINICIAN);
    }

    public void setClinician(User clinician) {
        this.setClinicianRef(clinician != null ? clinician.getObjectReference() : null);
    }

    public void setClinicianRef(Reference clinician) {
        this.setParticipant(CLINICIAN, clinician);
    }

    public void setQuantity(BigDecimal quantity) {
        this.getProperty(QUANTITY).setValue(quantity);
    }

    public BigDecimal getQuantity() {
        return this.getProperty(QUANTITY).getBigDecimal(BigDecimal.ZERO);
    }

    public void setFixedPrice(BigDecimal fixedPrice) {
        this.getProperty(FIXED_PRICE).setValue(fixedPrice);
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.getProperty(UNIT_PRICE).setValue(unitPrice);
    }

    public BigDecimal getUnitPrice() {
        return this.getProperty(UNIT_PRICE).getBigDecimal(BigDecimal.ZERO);
    }

    public void setDiscount(BigDecimal discount) {
        this.getProperty(DISCOUNT).setValue(discount);
    }

    public void setProductListener(ProductListener listener) {
        this.listener = listener;
    }

    public Party getLocation() {
        return this.location;
    }

    public Lookup getPricingGroup() {
        return this.pricingGroup;
    }

    public void setPrint(boolean print) {
        Property property = this.getProperty(PRINT);
        if (property != null) {
            property.setValue(print);
        }
    }

    public boolean getPrint() {
        boolean result = true;
        Property property = this.getProperty(PRINT);
        if (property != null) {
            result = property.getBoolean(true);
        }
        return result;
    }

    protected void productModified() {
        Participation participation = null;
        ProductParticipationEditor editor = this.getProductEditor();
        if (editor != null) {
            participation = editor.getParticipation();
        }
        if (participation != null) {
            this.productModified(participation);
        }
    }

    protected void productModified(Participation participation) {
        Product product = (Product)this.getObject(participation.getEntity());
        if (!this.currentTemplate) {
            this.setTemplateRef(null, -1);
        } else {
            this.currentTemplate = false;
        }
        this.productModified(product);
    }

    protected void productModified(Product product) {
    }

    protected void notifyProductListener(Product product) {
        if (this.listener != null) {
            this.listener.productChanged(this, product);
        }
    }

    protected ProductPrice getProductPrice(String shortName, Product product) {
        return this.rules.getProductPrice(product, shortName, this.getStartTime(), this.pricingGroup);
    }

    protected BigDecimal getMaxDiscount(ProductPrice price) {
        return price != null ? this.rules.getMaxDiscount(price) : ProductPriceRules.DEFAULT_MAX_DISCOUNT;
    }

    protected BigDecimal getCostPrice(ProductPrice price) {
        return price != null ? this.rules.getCostPrice(price) : BigDecimal.ZERO;
    }

    protected ProductParticipationEditor getProductEditor() {
        return this.getProductEditor(true);
    }

    protected ProductParticipationEditor getProductEditor(boolean create) {
        ParticipationEditor editor = this.getParticipationEditor(PRODUCT, create);
        return (ProductParticipationEditor)editor;
    }

    protected PatientParticipationEditor getPatientEditor() {
        return this.getPatientEditor(true);
    }

    protected PatientParticipationEditor getPatientEditor(boolean create) {
        ParticipationEditor editor = this.getParticipationEditor(PATIENT, create);
        return (PatientParticipationEditor)editor;
    }

    protected ClinicianParticipationEditor getClinicianEditor() {
        return this.getClinicianEditor(true);
    }

    protected ClinicianParticipationEditor getClinicianEditor(boolean create) {
        ParticipationEditor editor = this.getParticipationEditor(CLINICIAN, create);
        return (ClinicianParticipationEditor)editor;
    }

    @Override
    protected IMObjectLayoutStrategy createLayoutStrategy() {
        return new LayoutStrategy();
    }

    protected void changeLayout(ArchetypeNodes nodes) {
        this.setArchetypeNodes(nodes);
        this.onLayout();
    }

    protected void setArchetypeNodes(ArchetypeNodes nodes) {
        this.nodes = nodes;
    }

    protected ArchetypeNodes getArchetypeNodes() {
        return this.nodes;
    }

    @Override
    protected void onLayoutCompleted() {
        final ProductParticipationEditor product = this.getProductEditor();
        final PatientParticipationEditor patient = this.getPatientEditor();
        if (product != null) {
            product.addModifiableListener(this.productListener);
        }
        if (patient != null && product != null) {
            product.setPatient((Party)patient.getEntity());
            patient.getEditor().addModifiableListener(new ModifiableListener(){

                @Override
                public void modified(Modifiable modifiable) {
                    product.setPatient((Party)patient.getEntity());
                }
            });
        }
    }

    protected Party getLocation(Act parent, LayoutContext context) {
        IMObjectBean bean;
        Party location = null;
        if (parent != null && (bean = this.getBean((IMObject)parent)).hasNode(LOCATION)) {
            location = (Party)this.getObject(bean.getTargetRef(LOCATION));
        }
        if (location == null) {
            location = context.getContext().getLocation();
        }
        return location;
    }

    protected void setTemplate(Product template, int group) {
        this.setTemplateRef(template != null ? template.getObjectReference() : null, group);
    }

    protected void setTemplateRef(Reference template, int group) {
        CollectionProperty property = this.getCollectionProperty(TEMPLATE);
        if (property != null) {
            this.setParticipant(TEMPLATE, template);
            if (!property.isEmpty()) {
                IMObject object = (IMObject)property.getValues().get(0);
                IMObjectBean bean = this.getBean(object);
                bean.setValue(TEMPLATE_GROUP, (Object)(template != null ? Integer.valueOf(group) : null));
            }
            this.currentTemplate = template != null;
        }
    }

    private Lookup getPricingGroup(Party location) {
        Lookup result = null;
        if (location != null) {
            LocationRules locationRules = ServiceHelper.getBean(LocationRules.class);
            result = locationRules.getPricingGroup(location);
        }
        return result;
    }

    protected class LayoutStrategy
    extends AbstractLayoutStrategy {
        public LayoutStrategy() {
            super(ActItemEditor.this.nodes != null ? ActItemEditor.this.nodes : new ArchetypeNodes());
        }
    }
}

