/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit;

import java.util.List;
import java.util.Objects;
import nextapp.echo2.app.Component;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.edit.PropertyEditor;
import org.openvpms.web.component.im.edit.AbstractIMObjectCollectionEditor;
import org.openvpms.web.component.im.edit.AbstractSelectorPropertyEditor;
import org.openvpms.web.component.im.edit.CollectionPropertyEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.select.AbstractQuerySelector;
import org.openvpms.web.component.im.select.IMObjectSelector;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.echo.focus.FocusGroup;

public class SelectorIMObjectCollectionEditor
extends AbstractIMObjectCollectionEditor {
    private final PropertyEditor selector;

    public SelectorIMObjectCollectionEditor(CollectionProperty property, IMObject object, LayoutContext context) {
        super(property, object, context);
        this.selector = new Selector(property, context);
    }

    @Override
    public FocusGroup getFocusGroup() {
        return this.selector.getFocusGroup();
    }

    @Override
    protected Component doLayout(LayoutContext context) {
        return this.selector.getComponent();
    }

    private class Selector
    extends AbstractSelectorPropertyEditor<IMObject> {
        Selector(CollectionProperty property, LayoutContext context) {
            super(property, context);
            this.updateSelector();
        }

        @Override
        public IMObject getObject() {
            List objects = SelectorIMObjectCollectionEditor.this.getCollectionPropertyEditor().getObjects();
            return !objects.isEmpty() ? (IMObject)objects.get(0) : null;
        }

        @Override
        protected AbstractQuerySelector<IMObject> createSelector(Property property, LayoutContext context, boolean allowCreate) {
            return new IMObjectSelector<IMObject>(property.getDisplayName(), allowCreate, context, property.getArchetypeRange());
        }

        @Override
        protected boolean updateProperty(Property property, IMObject value) {
            boolean result = false;
            CollectionPropertyEditor editor = SelectorIMObjectCollectionEditor.this.getCollectionPropertyEditor();
            List objects = editor.getObjects();
            if (value == null) {
                for (IMObject object : objects) {
                    result |= editor.remove(object);
                }
            } else if (objects.size() == 1 && !Objects.equals(objects.get(0), value) || objects.size() > 1) {
                for (IMObject object : objects) {
                    editor.remove(object);
                }
                result = editor.add(value);
            } else if (objects.isEmpty()) {
                result = editor.add(value);
            }
            return result;
        }
    }
}

