/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit;

import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.list.ListCellRenderer;
import nextapp.echo2.app.list.ListModel;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.bound.BoundSelectFieldFactory;
import org.openvpms.web.component.im.edit.AbstractIMObjectCollectionEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.list.IMObjectListCellRenderer;
import org.openvpms.web.component.im.list.IMObjectListModel;
import org.openvpms.web.component.im.query.QueryHelper;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.system.ServiceHelper;

public class SelectFieldIMObjectCollectionEditor
extends AbstractIMObjectCollectionEditor {
    private FocusGroup focusGroup;

    public SelectFieldIMObjectCollectionEditor(CollectionProperty property, IMObject object, LayoutContext context) {
        super(property, object, context);
    }

    @Override
    public FocusGroup getFocusGroup() {
        return this.focusGroup;
    }

    @Override
    protected Component doLayout(LayoutContext context) {
        CollectionProperty property = this.getCollection();
        String[] nodes = DescriptorHelper.getCommonNodeNames((String[])property.getArchetypeRange(), (String[])this.DEFAULT_SORT_NODES, (ArchetypeService)ServiceHelper.getArchetypeService());
        List<IMObject> objects = QueryHelper.query(property.getArchetypeRange(), nodes);
        SelectField selectField = this.createSelectField(property, objects);
        this.focusGroup = new FocusGroup(property.getDisplayName());
        this.focusGroup.add((Component)selectField);
        return selectField;
    }

    protected SelectField createSelectField(CollectionProperty property, List<IMObject> objects) {
        IMObjectListModel model = this.createModel(property, objects);
        SelectField selectField = BoundSelectFieldFactory.create(property, (ListModel)model);
        selectField.setCellRenderer((ListCellRenderer)IMObjectListCellRenderer.NAME);
        return selectField;
    }

    protected IMObjectListModel createModel(CollectionProperty property, List<IMObject> objects) {
        boolean allowNone = property.getMinCardinality() == 0;
        return new IMObjectListModel((List<? extends IMObject>)objects, false, allowNone);
    }
}

