/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.handler.ArchetypeHandler;
import org.openvpms.component.business.service.archetype.handler.ArchetypeHandlers;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.edit.DefaultIMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.LayoutContext;

public class IMObjectEditorFactory {
    private final String name;
    private final String fallbackName;
    private final IArchetypeService service;
    private ArchetypeHandlers<IMObjectEditor> editors;
    private static final String NAME = "IMObjectEditorFactory.properties";
    private static final String FALLBACK_NAME = "DefaultIMObjectEditorFactory.properties";

    public IMObjectEditorFactory(IArchetypeService service) {
        this(NAME, FALLBACK_NAME, service);
    }

    public IMObjectEditorFactory(String name, String fallbackName, IArchetypeService service) {
        this.name = name;
        this.fallbackName = fallbackName;
        this.service = service;
    }

    public IMObjectEditor create(IMObject object, LayoutContext context) {
        return this.create(object, null, context);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IMObjectEditor create(IMObject object, IMObject parent, LayoutContext context) {
        void var4_10;
        String shortName = object.getArchetype();
        ArchetypeHandler handler = this.getEditors().getHandler(shortName);
        if (handler != null) {
            Class type = handler.getType();
            Constructor<?> ctor = this.getConstructor(type, object, parent, context);
            if (ctor == null) throw new IllegalStateException("No valid constructor found for class: " + type.getName());
            try {
                IMObjectEditor iMObjectEditor = (IMObjectEditor)ctor.newInstance(object, parent, context);
                return var4_10;
            }
            catch (InvocationTargetException exception) {
                if (!(exception.getCause() instanceof OpenVPMSException)) throw new IllegalStateException("Failed to construct " + type.getName() + " for " + object.getArchetype(), exception);
                throw (OpenVPMSException)exception.getCause();
            }
            catch (Throwable throwable) {
                throw new IllegalStateException("Failed to construct " + type.getName() + " for " + object.getArchetype(), throwable);
            }
        } else {
            DefaultIMObjectEditor defaultIMObjectEditor = new DefaultIMObjectEditor(object, parent, context);
        }
        return var4_10;
    }

    private synchronized ArchetypeHandlers<?> getEditors() {
        if (this.editors == null) {
            this.editors = new ArchetypeHandlers(this.name, this.fallbackName, IMObjectEditor.class, (ArchetypeService)this.service);
        }
        return this.editors;
    }

    private Constructor<?> getConstructor(Class<?> type, IMObject object, IMObject parent, LayoutContext context) {
        Constructor<?>[] ctors;
        for (Constructor<?> ctor : ctors = type.getConstructors()) {
            Class<?>[] ctorTypes = ctor.getParameterTypes();
            if (ctorTypes.length != 3) continue;
            Class<?> ctorObj = ctorTypes[0];
            Class<?> ctorParent = ctorTypes[1];
            Class<?> ctorLayout = ctorTypes[2];
            if (!ctorObj.isAssignableFrom(object.getClass()) || (parent == null || !ctorParent.isAssignableFrom(parent.getClass())) && (parent != null || !IMObject.class.isAssignableFrom(ctorParent)) || (context == null || !ctorLayout.isAssignableFrom(context.getClass())) && (context != null || !LayoutContext.class.isAssignableFrom(ctorLayout))) continue;
            return ctor;
        }
        return null;
    }
}

