/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit;

import org.openvpms.component.model.act.Act;
import org.openvpms.web.component.im.act.PrintedFlagUpdater;
import org.openvpms.web.component.im.edit.AbstractIMObjectActions;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.edit.ViewActActions;

public abstract class ActActions<T extends Act>
extends AbstractIMObjectActions<T> {
    private final boolean warnOnPrintUnfinalised;
    private static final ActActions<Act> EDIT = new ActActions<Act>(){};
    private static final ActActions<Act> EDIT_WARN_ON_PRINT_UNFINALISED = new ActActions<Act>(true){};

    public ActActions() {
        this(false);
    }

    public ActActions(boolean warnOnPrintUnfinalised) {
        this.warnOnPrintUnfinalised = warnOnPrintUnfinalised;
    }

    @Override
    public boolean canEdit(T act) {
        return super.canEdit(act) && !this.isLocked(act);
    }

    @Override
    public boolean canDelete(T act) {
        return super.canDelete(act) && !this.isLocked(act);
    }

    public boolean canPost(T act) {
        String status = act.getStatus();
        return !"POSTED".equals(status) && !"CANCELLED".equals(status);
    }

    public boolean post(T act) {
        if (this.canPost(act)) {
            act.setStatus("POSTED");
            return SaveHelper.save(act);
        }
        return false;
    }

    public T setPrinted(T act) {
        PrintedFlagUpdater updater = this.createPrintFlagUpdater();
        return updater.setPrinted(act);
    }

    public boolean isUnfinalised(Act act) {
        return !"POSTED".equals(act.getStatus());
    }

    public boolean warnWhenPrintingUnfinalisedAct() {
        return this.warnOnPrintUnfinalised;
    }

    public boolean isLocked(T act) {
        return "POSTED".equals(act.getStatus());
    }

    public static <T extends Act> ActActions<T> view() {
        return ViewActActions.getInstance();
    }

    public static <T extends Act> ActActions<T> edit() {
        return EDIT;
    }

    public static <T extends Act> ActActions<T> edit(boolean warnOnPrintUnfinalised) {
        return warnOnPrintUnfinalised ? EDIT_WARN_ON_PRINT_UNFINALISED : EDIT;
    }

    protected PrintedFlagUpdater createPrintFlagUpdater() {
        return new PrintedFlagUpdater();
    }
}

