/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit;

import nextapp.echo2.app.Component;
import org.openvpms.web.component.edit.AbstractPropertyEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.select.AbstractQuerySelector;
import org.openvpms.web.component.im.select.SelectorListener;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.echo.focus.FocusGroup;

public abstract class AbstractSelectorPropertyEditor<T>
extends AbstractPropertyEditor {
    private final LayoutContext context;
    private final AbstractQuerySelector<T> selector;
    private final ModifiableListener propertyListener;
    private boolean inListener;

    public AbstractSelectorPropertyEditor(Property property, LayoutContext context) {
        this(property, context, false);
    }

    public AbstractSelectorPropertyEditor(Property property, LayoutContext context, boolean allowCreate) {
        super(property);
        this.context = new DefaultLayoutContext(context, context.getHelpContext().subtopic("select"));
        this.selector = this.createSelector(property, this.context, allowCreate);
        this.selector.setListener(new SelectorListener<T>(){

            @Override
            public void selected(T object) {
                AbstractSelectorPropertyEditor.this.inListener = true;
                try {
                    AbstractSelectorPropertyEditor.this.onSelected(object);
                }
                finally {
                    AbstractSelectorPropertyEditor.this.inListener = false;
                }
            }

            @Override
            public void selected(T object, Browser<T> browser) {
                AbstractSelectorPropertyEditor.this.inListener = true;
                try {
                    AbstractSelectorPropertyEditor.this.onSelected(object, browser);
                }
                finally {
                    AbstractSelectorPropertyEditor.this.inListener = false;
                }
            }

            @Override
            public void create() {
                AbstractSelectorPropertyEditor.this.onCreate();
            }
        });
        this.selector.getSelect().setFocusTraversalParticipant(false);
        this.propertyListener = modifiable -> this.onUpdate();
        this.addModifiableListener(this.propertyListener);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.removeModifiableListener(this.propertyListener);
    }

    public boolean setObject(T object) {
        if (!this.inListener) {
            this.selector.setObject(object);
        }
        return this.updateProperty(object);
    }

    public abstract T getObject();

    @Override
    public Component getComponent() {
        return this.selector.getComponent();
    }

    @Override
    public FocusGroup getFocusGroup() {
        return this.selector.getFocusGroup();
    }

    protected abstract AbstractQuerySelector<T> createSelector(Property var1, LayoutContext var2, boolean var3);

    protected AbstractQuerySelector<T> getSelector() {
        return this.selector;
    }

    protected void onSelected(T object) {
        this.setObject(object);
    }

    protected void onSelected(T object, Browser<T> browser) {
        this.onSelected(object);
    }

    protected void onUpdated(T object) {
    }

    protected void onCreate() {
    }

    protected boolean updateProperty(T object) {
        Property property = this.getProperty();
        boolean modified = this.updateProperty(property, object);
        if (modified) {
            this.resetValid();
        }
        return modified;
    }

    protected abstract boolean updateProperty(Property var1, T var2);

    protected T updateSelector() {
        T object = this.getObject();
        this.selector.setObject(object);
        return object;
    }

    protected LayoutContext getLayoutContext() {
        return this.context;
    }

    private void onUpdate() {
        this.resetValid();
        T object = this.updateSelector();
        this.onUpdated(object);
    }
}

