/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit;

import nextapp.echo2.app.event.WindowPaneEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.AbstractSelectorPropertyEditor;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.im.edit.EditDialogFactory;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectReferenceEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.BrowserFactory;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.QueryFactory;
import org.openvpms.web.component.im.select.AbstractQuerySelector;
import org.openvpms.web.component.im.select.IMObjectSelector;
import org.openvpms.web.component.im.util.IMObjectCreator;
import org.openvpms.web.component.im.util.IMObjectCreatorListener;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public abstract class AbstractIMObjectReferenceEditor<T extends IMObject>
extends AbstractSelectorPropertyEditor<T>
implements IMObjectReferenceEditor<T> {
    private final IMObject parent;

    public AbstractIMObjectReferenceEditor(Property property, IMObject parent, LayoutContext context) {
        this(property, parent, context, false);
    }

    public AbstractIMObjectReferenceEditor(Property property, IMObject parent, LayoutContext context, boolean allowCreate) {
        super(property, context, allowCreate);
        this.parent = parent;
        this.updateSelector();
    }

    @Override
    public T getObject() {
        Property property = this.getProperty();
        Reference reference = property.getReference();
        IMObject object = null;
        if (reference != null) {
            object = IMObjectHelper.getObject(reference, property.getArchetypeRange(), this.getContext());
        }
        return (T)object;
    }

    @Override
    public boolean isNull() {
        return this.getProperty().getValue() == null && StringUtils.isEmpty((CharSequence)this.getSelector().getText());
    }

    @Override
    public void setAllowCreate(boolean create) {
        this.getSelector().setAllowCreate(create);
    }

    @Override
    public boolean allowCreate() {
        return this.getSelector().allowCreate();
    }

    @Override
    protected boolean doValidation(Validator validator) {
        boolean result = false;
        AbstractQuerySelector selector = this.getSelector();
        if (!selector.inSelect()) {
            if (!selector.isValid()) {
                String message = Messages.format((String)"imobject.invalidreference", (Object[])new Object[]{selector.getText()});
                validator.add((Modifiable)this, new ValidatorError(this.getProperty(), message));
            } else {
                result = super.doValidation(validator) && this.isValidReference(validator);
            }
        }
        return result;
    }

    @Override
    protected AbstractQuerySelector<T> createSelector(Property property, LayoutContext context, boolean allowCreate) {
        return new IMObjectSelector<T>(property, allowCreate, context){

            @Override
            protected Query<T> createQuery(String name) {
                return AbstractIMObjectReferenceEditor.this.createQuery(name);
            }

            @Override
            protected Browser<T> createBrowser(Query<T> query) {
                return AbstractIMObjectReferenceEditor.this.createBrowser(query);
            }
        };
    }

    protected Query<T> createQuery(String name) {
        String[] shortNames = this.getProperty().getArchetypeRange();
        Query query = QueryFactory.create(shortNames, this.getLayoutContext().getContext());
        query.setValue(name);
        return query;
    }

    protected Browser<T> createBrowser(Query<T> query) {
        return BrowserFactory.create(query, this.getLayoutContext());
    }

    @Override
    protected void onCreate() {
        IMObjectCreatorListener listener = new IMObjectCreatorListener(){

            @Override
            public void created(IMObject object) {
                AbstractIMObjectReferenceEditor.this.onCreated(object);
            }

            @Override
            public void cancelled() {
                AbstractIMObjectReferenceEditor.this.getFocusGroup().setFocus();
            }
        };
        IMObjectCreator.create(this.getProperty().getDisplayName(), this.getProperty().getArchetypeRange(), listener, this.getLayoutContext().getHelpContext());
    }

    protected void onCreated(IMObject object) {
        LocalContext context = new LocalContext(this.getContext());
        context.setCurrent(object);
        HelpContext help = this.getLayoutContext().getHelpContext().topic(object, "edit");
        DefaultLayoutContext layoutContext = new DefaultLayoutContext(true, (Context)context, help);
        final IMObjectEditor editor = layoutContext.getEditorFactory().create(object, this.parent, layoutContext);
        EditDialog dialog = ServiceHelper.getBean(EditDialogFactory.class).create(editor, context);
        dialog.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

            public void onClose(WindowPaneEvent event) {
                AbstractIMObjectReferenceEditor.this.getFocusGroup().setFocus();
                AbstractIMObjectReferenceEditor.this.onEditCompleted(editor);
            }
        });
        dialog.show();
    }

    protected void onEditCompleted(IMObjectEditor editor) {
        if (!editor.isCancelled() && !editor.isDeleted()) {
            this.setObject(editor.getObject());
        }
    }

    protected Context getContext() {
        return this.getLayoutContext().getContext();
    }

    @Override
    protected boolean updateProperty(Property property, T value) {
        boolean modified = value != null ? property.setValue(value.getObjectReference()) : property.setValue(null);
        return modified;
    }

    protected boolean isValidReference(Validator validator) {
        Reference reference = this.getProperty().getReference();
        boolean result = true;
        if (reference != null && !reference.isNew()) {
            result = this.isValidReference(reference, validator);
        }
        return result;
    }

    protected boolean isValidReference(Reference reference, Validator validator) {
        boolean result = this.isValidReference(reference);
        if (!result) {
            validator.add((Modifiable)this, this.createValidatorError(reference));
        }
        return result;
    }

    protected ValidatorError createValidatorError(Reference reference) {
        String displayName = DescriptorHelper.getDisplayName((String)reference.getArchetype(), (ArchetypeService)ServiceHelper.getArchetypeService());
        String message = Messages.format((String)"imobject.invalidreference", (Object[])new Object[]{displayName});
        return new ValidatorError(this.getProperty(), message);
    }

    protected boolean isValidReference(Reference reference) {
        Query<T> query = this.createQuery(null);
        return query.selects(reference);
    }
}

