/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit;

import nextapp.echo2.app.Component;
import org.apache.commons.lang3.ArrayUtils;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.edit.AlertListener;
import org.openvpms.web.component.im.edit.CollectionPropertyEditor;
import org.openvpms.web.component.im.edit.DefaultCollectionPropertyEditor;
import org.openvpms.web.component.im.edit.IMObjectCollectionEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.util.IMObjectCreator;
import org.openvpms.web.component.property.AbstractModifiable;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.ErrorListener;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.ModifiableListeners;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.system.ServiceHelper;

public abstract class AbstractIMObjectCollectionEditor
extends AbstractModifiable
implements IMObjectCollectionEditor {
    protected final String[] DEFAULT_SORT_NODES = new String[]{"name", "id"};
    private final CollectionPropertyEditor collection;
    private final IMObject object;
    private final LayoutContext context;
    private final ModifiableListeners listeners = new ModifiableListeners();
    private final ModifiableListener broadcaster;
    private Component component;
    private ErrorListener errorListener;
    private AlertListener alertListener;

    protected AbstractIMObjectCollectionEditor(CollectionProperty editor, IMObject object, LayoutContext context) {
        this(new DefaultCollectionPropertyEditor(editor), object, context);
    }

    protected AbstractIMObjectCollectionEditor(CollectionPropertyEditor editor, IMObject object, LayoutContext context) {
        this.collection = editor;
        this.object = object;
        this.context = context;
        this.broadcaster = new ModifiableListener(){

            @Override
            public void modified(Modifiable modifiable) {
                AbstractIMObjectCollectionEditor.this.onModified(modifiable);
            }
        };
        this.collection.addModifiableListener(this.broadcaster);
    }

    @Override
    public void dispose() {
        this.collection.removeModifiableListener(this.broadcaster);
        this.collection.setErrorListener(null);
    }

    @Override
    public Property getProperty() {
        return this.collection.getProperty();
    }

    @Override
    public Component getComponent() {
        if (this.component == null) {
            this.component = this.doLayout(this.context);
        }
        return this.component;
    }

    @Override
    public IMObject getObject() {
        return this.object;
    }

    @Override
    public CollectionProperty getCollection() {
        return this.collection.getProperty();
    }

    @Override
    public boolean isModified() {
        return this.collection.isModified();
    }

    @Override
    public void clearModified() {
        this.collection.clearModified();
    }

    @Override
    public void addModifiableListener(ModifiableListener listener) {
        this.listeners.addListener(listener);
    }

    @Override
    public void addModifiableListener(ModifiableListener listener, int index) {
        this.listeners.addListener(listener, index);
    }

    @Override
    public void removeModifiableListener(ModifiableListener listener) {
        this.listeners.removeListener(listener);
    }

    @Override
    public void setErrorListener(ErrorListener listener) {
        this.errorListener = listener;
    }

    @Override
    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    @Override
    public void setAlertListener(AlertListener listener) {
        this.alertListener = listener;
        for (IMObjectEditor editor : this.collection.getEditors()) {
            editor.setAlertListener(listener);
        }
    }

    @Override
    public AlertListener getAlertListener() {
        return this.alertListener;
    }

    @Override
    protected void resetValid(boolean descendants) {
        super.resetValid(descendants);
        if (descendants) {
            this.collection.resetValid();
        }
    }

    @Override
    public void save() {
        if (this.isModified()) {
            this.doSave();
            this.clearModified();
        }
    }

    @Override
    public boolean isSaved() {
        return this.collection.isSaved();
    }

    @Override
    public IMObject create(String archetype) {
        int maxSize;
        IMObject result = null;
        CollectionPropertyEditor editor = this.getCollectionPropertyEditor();
        if (archetype != null && ArrayUtils.contains((Object[])this.getCollectionPropertyEditor().getArchetypeRange(), (Object)archetype) && ((maxSize = editor.getMaxCardinality()) == -1 || editor.getObjects().size() < maxSize)) {
            result = IMObjectCreator.create(archetype);
        }
        return result;
    }

    @Override
    public boolean add(IMObject object) {
        return this.collection.add(object);
    }

    @Override
    public void remove(IMObject object) {
        this.collection.remove(object);
    }

    protected ModifiableListener getModifiableListener() {
        return this.broadcaster;
    }

    @Override
    protected boolean doValidation(Validator validator) {
        return this.collection.validate(validator);
    }

    protected abstract Component doLayout(LayoutContext var1);

    protected LayoutContext getContext() {
        return this.context;
    }

    protected CollectionPropertyEditor getCollectionPropertyEditor() {
        return this.collection;
    }

    protected ModifiableListeners getListeners() {
        return this.listeners;
    }

    protected void onModified(Modifiable modifiable) {
        this.resetValid(false);
        this.listeners.notifyListeners(modifiable);
    }

    protected void doSave() {
        this.collection.save();
    }

    protected IMObject getObject(Reference reference) {
        return this.context.getCache().get(reference);
    }

    protected IMObjectBean getBean(IMObject object) {
        return this.getService().getBean(object);
    }

    protected ArchetypeService getService() {
        return ServiceHelper.getArchetypeService();
    }
}

