/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.openvpms.component.business.service.archetype.ArchetypeServiceHelper;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.archetype.ArchetypeRange;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.edit.CollectionPropertyEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.property.AbstractModifiable;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.ErrorListener;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.ValidationHelper;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.system.ServiceHelper;

public abstract class AbstractCollectionPropertyEditor
extends AbstractModifiable
implements CollectionPropertyEditor {
    private final CollectionProperty property;
    private final Set<IMObject> edited = new HashSet<IMObject>();
    private final Map<IMObject, IMObjectEditor> editors = new HashMap<IMObject, IMObjectEditor>();
    private boolean saved;
    private CollectionPropertyEditor.RemoveHandler handler;

    public AbstractCollectionPropertyEditor(CollectionProperty property) {
        this.property = property;
    }

    @Override
    public CollectionProperty getProperty() {
        return this.property;
    }

    @Override
    public String[] getArchetypeRange() {
        return this.property.getArchetypeRange();
    }

    @Override
    public ArchetypeRange getArchetypes() {
        return this.property.getArchetypes();
    }

    @Override
    public boolean add(IMObject object) {
        boolean added = false;
        if (!this.property.getValues().contains(object)) {
            this.resetValid();
            this.property.add(object);
            added = true;
        }
        this.addEdited(object);
        return added;
    }

    @Override
    public void setEditor(IMObject object, IMObjectEditor editor) {
        this.resetValid();
        if (editor == null) {
            this.editors.remove(object);
        } else {
            this.editors.put(object, editor);
        }
    }

    @Override
    public IMObjectEditor getEditor(IMObject object) {
        return this.editors.get(object);
    }

    @Override
    public Collection<IMObjectEditor> getEditors() {
        return this.editors.values();
    }

    @Override
    public boolean remove(IMObject object) {
        boolean result = this.contains(object);
        IMObjectEditor editor = this.removeEdited(object);
        if (result |= editor != null) {
            this.remove(object, editor);
        }
        return result;
    }

    @Override
    public boolean isModified() {
        boolean modified = this.property.isModified();
        if (!modified) {
            for (IMObjectEditor editor : this.editors.values()) {
                if (!editor.isModified()) continue;
                modified = true;
                break;
            }
        }
        return modified;
    }

    @Override
    public void clearModified() {
        this.property.clearModified();
        for (IMObjectEditor editor : this.editors.values()) {
            editor.clearModified();
        }
    }

    @Override
    public void addModifiableListener(ModifiableListener listener) {
        this.property.addModifiableListener(listener);
    }

    @Override
    public void addModifiableListener(ModifiableListener listener, int index) {
        this.property.addModifiableListener(listener, index);
    }

    @Override
    public void removeModifiableListener(ModifiableListener listener) {
        this.property.removeModifiableListener(listener);
    }

    @Override
    public void setErrorListener(ErrorListener listener) {
        this.property.setErrorListener(listener);
    }

    @Override
    public ErrorListener getErrorListener() {
        return this.property.getErrorListener();
    }

    @Override
    public void save() {
        this.doSave();
        this.clearModified();
    }

    @Override
    public boolean isSaved() {
        return this.saved;
    }

    @Override
    public <T extends IMObject> List<T> getObjects() {
        List objects = Collections.emptyList();
        List<?> values = this.property.getValues();
        int size = values.size();
        if (size != 0) {
            objects = new ArrayList();
            for (Object value : values) {
                objects.add((IMObject)value);
            }
        }
        return objects;
    }

    @Override
    public <T extends IMObject> List<T> getObjects(Predicate<T> predicate) {
        List result;
        List<T> objects = this.getObjects();
        if (!objects.isEmpty()) {
            result = new ArrayList();
            CollectionUtils.select(objects, predicate, result);
        } else {
            result = Collections.emptyList();
        }
        return result;
    }

    @Override
    public int getMinCardinality() {
        return this.property.getMinCardinality();
    }

    @Override
    public int getMaxCardinality() {
        return this.property.getMaxCardinality();
    }

    @Override
    public void setRemoveHandler(CollectionPropertyEditor.RemoveHandler handler) {
        this.handler = handler;
    }

    @Override
    public CollectionPropertyEditor.RemoveHandler getRemoveHandler() {
        return this.handler;
    }

    protected boolean contains(IMObject object) {
        return this.property.getValues().contains(object);
    }

    protected void remove(IMObject object, IMObjectEditor editor) {
        this.resetValid();
        this.property.remove(object);
    }

    @Override
    protected boolean doValidation(Validator validator) {
        boolean result = validator.validate(this.property);
        if (result) {
            List<IMObject> objects = this.getObjects();
            result = this.validate(validator, objects);
        }
        return result;
    }

    protected boolean validate(Validator validator, List<IMObject> objects) {
        boolean result = true;
        IArchetypeRuleService service = ServiceHelper.getArchetypeService();
        for (IMObject object : objects) {
            if (this.validate(object, validator, (ArchetypeService)service)) continue;
            result = false;
            break;
        }
        return result;
    }

    protected boolean validate(IMObject object, Validator validator, ArchetypeService service) {
        boolean result = true;
        IMObjectEditor editor = this.getEditor(object);
        if (editor != null) {
            if (!validator.validate(editor)) {
                result = false;
            }
        } else {
            List<ValidatorError> errors = ValidationHelper.validate(object, service);
            if (errors != null) {
                validator.add((Modifiable)this.property, errors);
                result = false;
            }
        }
        return result;
    }

    @Override
    protected void resetValid(boolean descendants) {
        super.resetValid(descendants);
        if (descendants) {
            for (IMObjectEditor editor : this.editors.values()) {
                editor.resetValid();
            }
        }
    }

    protected void doSave() {
        this.saved = false;
        if (!this.edited.isEmpty() || !this.editors.isEmpty()) {
            IMObject[] edited;
            for (IMObjectEditor editor : this.editors.values()) {
                editor.save();
                this.edited.remove(editor.getObject());
                this.saved = true;
            }
            IArchetypeService service = ArchetypeServiceHelper.getArchetypeService();
            for (IMObject object : edited = this.edited.toArray(new IMObject[0])) {
                this.save(object, service);
                this.edited.remove(object);
                this.saved = true;
            }
        }
    }

    protected void save(IMObject object, IArchetypeService service) {
        service.save(object);
    }

    protected void setSaved(boolean saved) {
        this.saved = saved;
    }

    protected void addEdited(IMObject object) {
        if (this.edited.add(object)) {
            this.resetValid(false);
        }
    }

    protected IMObjectEditor removeEdited(IMObject object) {
        boolean changed;
        IMObjectEditor result = this.editors.remove(object);
        boolean bl = changed = result != null;
        if (changed |= this.edited.remove(object)) {
            this.resetValid(false);
        }
        return result;
    }
}

