/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.doc;

import org.apache.commons.beanutils.ConstructorUtils;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.handler.ArchetypeHandler;
import org.openvpms.component.business.service.archetype.handler.ArchetypeHandlers;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.doc.DocumentViewer;
import org.openvpms.web.component.im.layout.LayoutContext;

public class DocumentViewerFactory {
    private final ArchetypeHandlers<DocumentViewer> viewers;

    public DocumentViewerFactory(IArchetypeService service) {
        this.viewers = new ArchetypeHandlers("DocumentViewerFactory", "DefaultDocumentViewerFactory", DocumentViewer.class, (ArchetypeService)service);
    }

    public DocumentViewer create(DocumentAct act, boolean link, LayoutContext context) {
        Class<?> type = this.getType((IMObject)act);
        try {
            return (DocumentViewer)ConstructorUtils.invokeConstructor(type, (Object[])new Object[]{act, link, context});
        }
        catch (Throwable exception) {
            throw new IllegalStateException("Failed to construct " + type.getName() + " for " + act.getArchetype(), exception);
        }
    }

    public DocumentViewer create(DocumentAct act, boolean link, boolean template, LayoutContext context) {
        Class<?> type = this.getType((IMObject)act);
        try {
            return (DocumentViewer)ConstructorUtils.invokeConstructor(type, (Object[])new Object[]{act, link, template, context});
        }
        catch (Throwable exception) {
            throw new IllegalStateException("Failed to construct " + type.getName() + " for " + act.getArchetype(), exception);
        }
    }

    private Class<?> getType(IMObject object) {
        ArchetypeHandler handler = this.viewers.getHandler(object.getArchetype());
        return handler != null ? handler.getType() : DocumentViewer.class;
    }
}

