/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.doc;

import java.util.List;
import nextapp.echo2.app.Component;
import org.openvpms.archetype.rules.doc.DelegatingDocumentHandler;
import org.openvpms.archetype.rules.doc.DocumentHandler;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.archetype.rules.doc.SupportedContentDocumentHandler;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.report.jasper.JRXMLDocumentHandler;
import org.openvpms.web.component.edit.PropertyComponentEditor;
import org.openvpms.web.component.im.doc.AbstractDocumentTemplateEditor;
import org.openvpms.web.component.im.doc.DocumentTemplateLayoutStrategy;
import org.openvpms.web.component.im.doc.DocumentUploadListener;
import org.openvpms.web.component.im.doc.UploadDialog;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.list.LookupListCellRenderer;
import org.openvpms.web.component.im.list.LookupListModel;
import org.openvpms.web.component.im.lookup.BoundLookupField;
import org.openvpms.web.component.im.lookup.LookupFieldFactory;
import org.openvpms.web.component.im.lookup.NodeLookupQuery;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class DocumentTemplateEditor
extends AbstractDocumentTemplateEditor {
    private final Property outputFormat;
    private final PropertyComponentEditor outputFormatEditor;
    private boolean letter;
    static final String TYPE = "type";
    static final String OUTPUT_FORMAT = "outputFormat";

    public DocumentTemplateEditor(Entity template, IMObject parent, LayoutContext context) {
        super(template, parent, false, null, context);
        String type = this.getTypeCode();
        this.updateDocumentHandler(type);
        this.letter = DocumentTemplate.isLetter((String)type);
        this.getProperty(TYPE).addModifiableListener(modifiable -> this.onTypeChanged());
        this.outputFormat = this.getProperty(OUTPUT_FORMAT);
        BoundLookupField field = new BoundLookupField(this.outputFormat, new LookupListModel(new NodeLookupQuery((IMObject)template, this.outputFormat), false, false, true));
        LookupFieldFactory.setDefaultStyle((Component)field);
        field.setCellRenderer(LookupListCellRenderer.INSTANCE);
        field.setEnabled(this.letter);
        this.outputFormatEditor = new PropertyComponentEditor(this.outputFormat, (Component)field);
        if (type == null) {
            this.enableUpload(false);
        }
    }

    @Override
    public IMObjectEditor newInstance() {
        return new DocumentTemplateEditor((Entity)this.reload(this.getObject()), this.getParent(), this.getLayoutContext());
    }

    public String getTypeCode() {
        Lookup type = this.getType();
        return type != null ? type.getCode() : null;
    }

    public void setTypeCode(String code) {
        CollectionProperty property;
        List<?> values;
        Lookup lookup = null;
        if (code != null) {
            LookupService lookups = ServiceHelper.getLookupService();
            lookup = lookups.getLookup("lookup.documentTemplateType", code);
        }
        if (!(values = (property = this.getCollectionProperty(TYPE)).getValues()).isEmpty()) {
            property.remove(values.get(0));
        }
        if (lookup != null) {
            property.add(lookup);
        }
    }

    @Override
    protected IMObjectLayoutStrategy createLayoutStrategy() {
        DocumentTemplateLayoutStrategy strategy = new DocumentTemplateLayoutStrategy(this.getSelector());
        strategy.addComponent(new ComponentState(this.outputFormatEditor));
        return strategy;
    }

    @Override
    protected void onUpload() {
        DocumentUploadListener listener = new DocumentUploadListener(this.getDocumentHandler()){

            @Override
            protected void upload(Document doc) {
                DocumentTemplateEditor.this.onUpload(doc);
            }

            @Override
            protected boolean checkSupported(String fileName, String contentType) {
                boolean supported = DocumentTemplateEditor.this.isContentSupported(fileName, contentType);
                if (!supported) {
                    ErrorHelper.show(DocumentTemplateEditor.this.getUnsupportedContentMessage(fileName));
                }
                return supported;
            }
        };
        UploadDialog dialog = new UploadDialog(listener, this.getLayoutContext().getHelpContext());
        dialog.show();
    }

    @Override
    protected boolean validateContent(String fileName, String mimeType, Validator validator, Property content) {
        boolean valid = this.isContentSupported(fileName, mimeType);
        if (!valid) {
            validator.add((Modifiable)content, this.getUnsupportedContentMessage(fileName));
        }
        return valid;
    }

    private String getUnsupportedContentMessage(String fileName) {
        Lookup type = this.getType();
        String name = type != null ? type.getName() : Messages.get((String)"imobject.none");
        return Messages.format((String)"document.template.unsupportedcontent", (Object[])new Object[]{fileName, name});
    }

    private void updateDocumentHandler(String type) {
        IArchetypeService service = this.getService();
        if (DocumentTemplate.isReport((String)type)) {
            this.setDocumentHandler((DocumentHandler)new JRXMLDocumentHandler((ArchetypeService)service));
        } else if (DocumentTemplate.isForm((String)type)) {
            this.setDocumentHandler((DocumentHandler)new DelegatingDocumentHandler(new DocumentHandler[]{new MergeableDocumentTemplateHandler((ArchetypeService)service), new JRXMLDocumentHandler((ArchetypeService)service), new StaticDocumentTemplateHandler((ArchetypeService)service)}));
        } else {
            this.setDocumentHandler((DocumentHandler)new DelegatingDocumentHandler(new DocumentHandler[]{new MergeableDocumentTemplateHandler((ArchetypeService)service), new JRXMLDocumentHandler((ArchetypeService)service)}));
        }
    }

    private Lookup getType() {
        return (Lookup)this.getBean(this.getObject()).getObject(TYPE, Lookup.class);
    }

    private void onTypeChanged() {
        String type = this.getTypeCode();
        boolean newLetter = DocumentTemplate.isLetter((String)type);
        if (newLetter != this.letter) {
            this.letter = newLetter;
            if (!this.letter) {
                this.outputFormat.setValue(null);
            }
            this.outputFormatEditor.getComponent().setEnabled(this.letter);
        }
        this.updateDocumentHandler(type);
        this.enableUpload(type != null);
    }

    private static class StaticDocumentTemplateHandler
    extends SupportedContentDocumentHandler {
        private static final String[] SUPPORTED_EXTENSIONS = new String[]{"pdf"};
        private static final String[] SUPPORTED_MIME_TYPES = new String[]{"application/pdf"};

        public StaticDocumentTemplateHandler(ArchetypeService service) {
            super(SUPPORTED_EXTENSIONS, SUPPORTED_MIME_TYPES, service);
        }
    }

    private static class MergeableDocumentTemplateHandler
    extends SupportedContentDocumentHandler {
        private static final String[] SUPPORTED_EXTENSIONS = new String[]{"odt", "doc", "rtf"};
        private static final String[] SUPPORTED_MIME_TYPES = new String[]{"application/vnd.oasis.opendocument.text", "application/msword", "text/rtf"};

        public MergeableDocumentTemplateHandler(ArchetypeService service) {
            super(SUPPORTED_EXTENSIONS, SUPPORTED_MIME_TYPES, service);
        }
    }
}

