/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.doc;

import java.util.function.Consumer;
import org.openvpms.archetype.rules.doc.DocumentRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.doc.DocumentActLayoutStrategy;
import org.openvpms.web.component.im.doc.DocumentEditor;
import org.openvpms.web.component.im.doc.DocumentGenerator;
import org.openvpms.web.component.im.doc.DocumentGeneratorFactory;
import org.openvpms.web.component.im.doc.DocumentTemplateParticipationEditor;
import org.openvpms.web.component.im.edit.act.AbstractActEditor;
import org.openvpms.web.component.im.edit.act.ActRelationshipCollectionEditor;
import org.openvpms.web.component.im.edit.act.DocumentVersionsCollectionEditor;
import org.openvpms.web.component.im.edit.act.ParticipationEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.DefaultValidator;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.ValidationHelper;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;

public class DocumentActEditor
extends AbstractActEditor {
    private Reference lastTemplate;
    private DocumentEditor docEditor;
    private DocumentStatus documentStatus = DocumentStatus.UP_TO_DATE;
    private ActRelationshipCollectionEditor versionsEditor;
    private static final String DOC_TEMPLATE = "documentTemplate";

    public DocumentActEditor(DocumentAct act, IMObject parent, LayoutContext context) {
        super((Act)act, parent, context);
        Property versions;
        Property document = this.getProperty("document");
        if (document != null) {
            HelpContext help = context.getHelpContext().topic("document");
            this.docEditor = new VersioningDocumentEditor(document, new DefaultLayoutContext(context, help));
            ModifiableListener listener = modifiable -> this.onDocumentUpdate();
            this.docEditor.addModifiableListener(listener);
            this.addEditor(this.docEditor);
        }
        if ((versions = this.getProperty("versions")) != null) {
            this.versionsEditor = new DocumentVersionsCollectionEditor((CollectionProperty)versions, (Act)act, context);
            this.addEditor(this.versionsEditor);
        }
        this.lastTemplate = this.getTemplateRef();
    }

    public DocumentAct getObject() {
        return (DocumentAct)super.getObject();
    }

    public void setTemplate(Entity template) {
        this.setParticipant(DOC_TEMPLATE, template);
    }

    public Entity getTemplate() {
        return this.getParticipant(DOC_TEMPLATE);
    }

    public void setTemplateRef(Reference template) {
        this.setParticipant(DOC_TEMPLATE, template);
    }

    public Reference getTemplateRef() {
        return this.getParticipantRef(DOC_TEMPLATE);
    }

    public void setDocument(Document document) {
        if (this.docEditor == null) {
            throw new IllegalStateException("Documents are not supported by: " + this.getDisplayName());
        }
        this.docEditor.setDocument(document);
    }

    public Document getDocument() {
        return (Document)this.getObject(this.getDocumentRef());
    }

    public Reference getDocumentRef() {
        if (this.docEditor == null) {
            throw new IllegalStateException("Documents are not supported by: " + this.getDisplayName());
        }
        return this.docEditor.getReference();
    }

    public DocumentStatus getDocumentStatus() {
        return this.documentStatus;
    }

    public void resetDocumentStatus() {
        this.documentStatus = DocumentStatus.UP_TO_DATE;
    }

    public void generateDocument(Consumer<Boolean> listener) {
        DefaultValidator validator = new DefaultValidator();
        if (!this.validate(validator)) {
            ValidationHelper.showError(validator);
            listener.accept(false);
        } else {
            this.generate(listener);
        }
    }

    @Override
    protected void onLayoutCompleted() {
        super.onLayoutCompleted();
        DocumentTemplateParticipationEditor editor = this.getDocumentTemplateEditor();
        if (editor != null) {
            editor.addModifiableListener(modifiable -> this.onTemplateUpdate());
        }
    }

    @Override
    protected void doSave() {
        this.saveObject();
        this.saveChildren();
    }

    @Override
    protected void doDelete() {
        DocumentAct act = this.getObject();
        if (act.getDocument() != null) {
            act.setDocument(null);
            this.getService().save((IMObject)act);
        }
        super.doDelete();
    }

    @Override
    protected IMObjectLayoutStrategy createLayoutStrategy() {
        return new DocumentActLayoutStrategy(this.docEditor, this.versionsEditor);
    }

    protected DocumentEditor getDocumentEditor() {
        return this.docEditor;
    }

    protected ActRelationshipCollectionEditor getVersionsEditor() {
        return this.versionsEditor;
    }

    protected DocumentTemplateParticipationEditor getDocumentTemplateEditor() {
        ParticipationEditor editor = this.getParticipationEditor(DOC_TEMPLATE, true);
        return editor instanceof DocumentTemplateParticipationEditor ? (DocumentTemplateParticipationEditor)editor : null;
    }

    protected void documentAttributeModified(boolean mandatory) {
        if (mandatory || this.docEditor != null && this.docEditor.getReference() == null) {
            this.setDocumentStatus(DocumentStatus.NEEDS_UPDATE);
        } else if (this.documentStatus != DocumentStatus.NEEDS_UPDATE) {
            this.setDocumentStatus(DocumentStatus.PROMPT);
        }
    }

    protected void setDocumentStatus(DocumentStatus documentStatus) {
        this.documentStatus = documentStatus;
    }

    private void onDocumentUpdate() {
        this.getProperty("fileName").setValue(this.docEditor.getName());
        this.getProperty("mimeType").setValue(this.docEditor.getMimeType());
    }

    private void onTemplateUpdate() {
        Reference template = this.getTemplateRef();
        if (template != null && this.lastTemplate != null && !template.equals((Object)this.lastTemplate) || template != null && this.lastTemplate == null) {
            this.lastTemplate = template;
            if (this.docEditor != null) {
                this.documentAttributeModified(true);
            }
        }
    }

    private void generate(final Consumer<Boolean> listener) {
        DocumentAct act = this.getObject();
        Context context = this.getLayoutContext().getContext();
        HelpContext help = this.getLayoutContext().getHelpContext();
        DocumentGenerator.AbstractListener generationListener = new DocumentGenerator.AbstractListener(){

            @Override
            public void generated(Document document) {
                DocumentActEditor.this.docEditor.setDocument(document);
                DocumentActEditor.this.documentStatus = DocumentStatus.UP_TO_DATE;
                listener.accept(true);
            }
        };
        DocumentGeneratorFactory factory = ServiceHelper.getBean(DocumentGeneratorFactory.class);
        DocumentGenerator generator = factory.create(act, context, help, generationListener);
        try {
            generator.generate();
        }
        catch (Exception exception) {
            ErrorHelper.show((Throwable)exception, () -> listener.accept(false));
        }
    }

    private boolean versionOldDocument(Reference reference) {
        DocumentRules rules;
        DocumentAct version;
        boolean versioned = false;
        if (reference != null && !reference.isNew() && this.versionsEditor != null && (version = (rules = ServiceHelper.getBean(DocumentRules.class)).createVersion(this.getObject())) != null) {
            this.versionsEditor.add((IMObject)version);
            this.versionsEditor.refresh();
            versioned = true;
        }
        return versioned;
    }

    private class VersioningDocumentEditor
    extends DocumentEditor {
        public VersioningDocumentEditor(Property property, LayoutContext context) {
            super(property, context);
        }

        @Override
        public void setDocument(Document document) {
            boolean versioned = DocumentActEditor.this.versionOldDocument(this.getReference());
            super.setDocument(document, versioned);
        }
    }

    public static enum DocumentStatus {
        NEEDS_UPDATE,
        PROMPT,
        UP_TO_DATE;

    }
}

