/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.doc;

import java.util.List;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.ActionEvent;
import org.openvpms.archetype.rules.doc.DocumentHandler;
import org.openvpms.archetype.rules.doc.SupportedImageDocumentHandler;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.edit.Cancellable;
import org.openvpms.web.component.edit.Deletable;
import org.openvpms.web.component.im.doc.DocReferenceMgr;
import org.openvpms.web.component.im.doc.DocumentUploadListener;
import org.openvpms.web.component.im.doc.UploadDialog;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.select.BasicSelector;
import org.openvpms.web.component.property.AbstractSaveableEditor;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.ValidationHelper;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class AbstractImageParticipationEditor
extends AbstractSaveableEditor
implements Deletable,
Cancellable {
    private final ArchetypeService service;
    private final String documentArchetype;
    private final String node;
    private final BasicSelector<DocumentAct> selector;
    private final DocReferenceMgr refMgr;
    private final Button remove;
    private final LayoutContext context;
    private final Entity parent;
    private final DocumentHandler handler;
    private DocumentAct act;
    private Component component;

    public AbstractImageParticipationEditor(DocumentAct act, Entity parent, String archetype, String node, LayoutContext context) {
        this.act = act;
        this.documentArchetype = archetype;
        this.node = node;
        this.service = ServiceHelper.getArchetypeService();
        if (act.isNew()) {
            IMObjectBean bean = this.service.getBean((IMObject)act);
            bean.setTarget(node, (IMObject)parent);
        }
        this.parent = parent;
        this.context = context;
        this.handler = new SupportedImageDocumentHandler(this.service);
        this.selector = new BasicSelector("button.upload");
        this.selector.getSelect().addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                AbstractImageParticipationEditor.this.onSelect();
            }
        });
        this.refMgr = new DocReferenceMgr(act.getDocument(), this.service);
        this.remove = ButtonFactory.create(null, (String)"button.remove", this::removeDocument);
    }

    public boolean hasImage() {
        return this.act != null && this.act.getDocument() != null;
    }

    public void setImage(Document document) {
        this.onUpload(document);
    }

    @Override
    public Component getComponent() {
        if (this.component == null) {
            this.updateDisplay();
            this.component = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{this.selector.getComponent(), this.remove});
            FocusGroup focusGroup = this.getFocusGroup();
            focusGroup.add(this.selector.getComponent());
            focusGroup.add((Component)this.remove);
        }
        return this.component;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.component != null) {
            this.component.removeAll();
        }
    }

    @Override
    public void delete() {
        if (this.act != null && !this.act.isNew()) {
            this.service.remove((IMObject)this.act);
            this.act = null;
        }
        this.refMgr.delete();
    }

    @Override
    public void cancel() {
        this.refMgr.rollback();
    }

    @Override
    protected boolean doValidation(Validator validator) {
        boolean result = true;
        List<ValidatorError> errors = ValidationHelper.validate((IMObject)this.act, this.service);
        if (errors != null) {
            validator.add((Modifiable)this, errors);
            result = false;
        }
        return result;
    }

    @Override
    protected void doSave() {
        if (this.act != null) {
            if (this.act.getDocument() == null) {
                if (!this.act.isNew()) {
                    this.service.save((IMObject)this.act);
                    this.refMgr.commit();
                    this.service.remove((IMObject)this.act);
                    this.act = null;
                }
            } else {
                this.service.save((IMObject)this.act);
                this.refMgr.commit();
                if (this.act.getDocument() == null) {
                    this.service.remove((IMObject)this.act);
                    this.act = null;
                }
            }
        }
    }

    protected DocumentAct createAct() {
        DocumentAct act = (DocumentAct)this.service.create(this.documentArchetype, DocumentAct.class);
        IMObjectBean bean = this.service.getBean((IMObject)act);
        bean.setTarget(this.node, (IMObject)this.parent);
        return act;
    }

    protected void populateAct(DocumentAct act, Document document) {
        act.setFileName(document.getName());
        this.service.deriveValue((IMObject)act, "name");
        act.setMimeType(document.getMimeType());
        IMObjectBean bean = this.service.getBean((IMObject)document);
        int width = bean.getInt("width");
        int height = bean.getInt("height");
        String description = this.getDescription(width, height);
        act.setDescription(description);
    }

    protected String getDescription(int width, int height) {
        String result = width != -1 && height != -1 ? Messages.format((String)"document.description.size", (Object[])new Object[]{width, height}) : Messages.format((String)"document.description.unknownsize", (Object[])new Object[]{width, height});
        return result;
    }

    protected void onSelect() {
        DocumentUploadListener listener = new DocumentUploadListener(this.handler){

            @Override
            protected void upload(Document doc) {
                AbstractImageParticipationEditor.this.onUpload(doc);
            }
        };
        UploadDialog dialog = new UploadDialog(listener, this.context.getHelpContext());
        dialog.show();
    }

    protected void onUpload(Document document) {
        this.service.save((IMObject)document);
        if (this.act == null) {
            this.act = this.createAct();
        }
        this.populateAct(this.act, document);
        this.replaceDocument(document);
        this.updateDisplay();
        this.setModified();
        this.notifyListeners();
    }

    protected void removeDocument() {
        this.replaceDocument(null);
        if (this.act != null) {
            this.act.setFileName(null);
            this.act.setName(null);
            this.act.setMimeType(null);
            this.act.setDescription(null);
        }
        this.updateDisplay();
        this.setModified();
        this.notifyListeners();
    }

    protected void updateDisplay() {
        this.selector.setObject(this.act);
        this.remove.setVisible(this.act != null && this.act.getDocument() != null);
    }

    private void replaceDocument(Document document) {
        if (document != null) {
            Reference ref = document.getObjectReference();
            this.act.setDocument(ref);
            this.refMgr.add(ref);
        } else {
            if (this.act != null) {
                this.act.setDocument(null);
            }
            this.refMgr.setDeleteAll(true);
        }
    }
}

