/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.doc;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.event.ActionEvent;
import org.apache.commons.lang3.ArrayUtils;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.ShortNameConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.list.LookupListCellRenderer;
import org.openvpms.web.component.im.lookup.ArchetypeLookupQuery;
import org.openvpms.web.component.im.lookup.LookupField;
import org.openvpms.web.component.im.lookup.LookupFieldFactory;
import org.openvpms.web.component.im.query.AbstractIMObjectQuery;
import org.openvpms.web.component.im.query.EmptyResultSet;
import org.openvpms.web.component.im.query.EntityResultSet;
import org.openvpms.web.component.im.query.QueryFactory;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.focus.FocusHelper;

public abstract class AbstractDocumentTemplateQuery
extends AbstractIMObjectQuery<Entity> {
    private String[] types = new String[0];
    private Label typeFieldLabel;
    private LookupField typeField;

    public AbstractDocumentTemplateQuery(String[] shortNames) {
        super(shortNames, Entity.class);
        this.setDefaultSortConstraint(NAME_SORT_CONSTRAINT);
        QueryFactory.initialise(this);
    }

    public void setTemplateTypes(String ... types) {
        this.types = types;
    }

    @Override
    protected void onShortNameChanged() {
        if (this.typeField != null) {
            String archetype = this.getShortName();
            boolean visible = archetype == null || "entity.documentTemplate".equals(archetype);
            this.typeField.setVisible(visible);
            this.typeFieldLabel.setVisible(visible);
        }
    }

    @Override
    protected void doLayout(Component container) {
        this.addShortNameSelector(container);
        this.addSearchField(container);
        this.addActive(container);
        this.addTypeSelector(container);
        FocusHelper.setFocus((Component)this.getSearchField());
    }

    protected void addTypeSelector(Component container) {
        if (ArrayUtils.contains((Object[])this.getShortNames(), (Object)"entity.documentTemplate")) {
            this.typeFieldLabel = LabelFactory.create((String)"document.template.type");
            ArchetypeLookupQuery lookups = new ArchetypeLookupQuery("lookup.documentTemplateType", this.types);
            this.typeField = LookupFieldFactory.create(lookups, true);
            this.typeField.setSelected((Lookup)null);
            this.typeField.setCellRenderer(LookupListCellRenderer.INSTANCE);
            this.typeField.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                public void onAction(ActionEvent event) {
                    AbstractDocumentTemplateQuery.this.onQuery();
                }
            });
            container.add((Component)this.typeFieldLabel);
            container.add((Component)this.typeField);
            this.getFocusGroup().add((Component)this.typeField);
        }
    }

    @Override
    protected ResultSet<Entity> createResultSet(SortConstraint[] sort) {
        ResultSet<Entity> result;
        String[] selectedTypes = this.getSelectedTypes();
        ShortNameConstraint archetypes = this.getArchetypeConstraint();
        if (selectedTypes.length > 0) {
            if (!ArrayUtils.contains((Object[])archetypes.getShortNames(), (Object)"entity.documentTemplate")) {
                result = new EmptyResultSet<Entity>(this.getMaxResults());
            } else if (archetypes.getShortNames().length > 1) {
                archetypes = new ShortNameConstraint("entity.documentTemplate", this.getActive());
                result = this.createResultSet(archetypes, selectedTypes, sort);
            } else {
                result = this.createResultSet(archetypes, selectedTypes, sort);
            }
        } else {
            result = this.createResultSet(archetypes, selectedTypes, sort);
        }
        return result;
    }

    protected ResultSet<Entity> createResultSet(ShortNameConstraint archetypes, String[] types, SortConstraint[] sort) {
        return new TemplateResultSet(archetypes, this.getValue(), sort, this.getMaxResults(), types, this.isDistinct());
    }

    protected String[] getSelectedTypes() {
        String type;
        String string = type = this.typeField != null && this.typeField.isVisible() ? this.typeField.getSelectedCode() : null;
        String[] typeFilter = type != null ? new String[]{type} : (this.types.length > 0 ? this.types : new String[]{});
        return typeFilter;
    }

    protected static class TemplateResultSet
    extends EntityResultSet<Entity> {
        private final String[] types;

        public TemplateResultSet(ShortNameConstraint archetypes, String value, SortConstraint[] sort, int rows, String[] types, boolean distinct) {
            super(archetypes, value, false, null, sort, rows, distinct);
            this.types = types;
        }

        @Override
        protected ArchetypeQuery createQuery() {
            ArchetypeQuery query = super.createQuery();
            if (this.types.length != 0) {
                query.add((IConstraint)Constraints.join((String)"type").add((IConstraint)Constraints.in((String)"code", (Object[])this.types)));
            }
            return query;
        }
    }
}

