/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.delete;

import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.web.component.im.delete.AbstractIMObjectDeletionHandler;
import org.openvpms.web.component.im.delete.Deletable;
import org.openvpms.web.component.im.edit.IMObjectEditorFactory;
import org.openvpms.web.resource.i18n.Messages;
import org.springframework.transaction.PlatformTransactionManager;

public abstract class AbstractEntityDeletionHandler<T extends Entity>
extends AbstractIMObjectDeletionHandler<T> {
    public static final String[] DEFAULT_PARTICIPATIONS = new String[]{"participation.*"};
    private final String[] exclude;

    public AbstractEntityDeletionHandler(T object, IMObjectEditorFactory factory, PlatformTransactionManager transactionManager, IArchetypeRuleService service) {
        this(object, null, factory, transactionManager, service);
    }

    public AbstractEntityDeletionHandler(T object, String[] exclude, IMObjectEditorFactory factory, PlatformTransactionManager transactionManager, IArchetypeRuleService service) {
        super(object, factory, transactionManager, service);
        this.exclude = exclude;
    }

    @Override
    public Deletable getDeletable() {
        Entity object = (Entity)this.getObject();
        if (this.hasParticipations(object, this.getParticipations()) || this.hasMatches(object, this.exclude)) {
            return Deletable.no(Messages.format((String)"imobject.delete.relationships", (Object[])new Object[]{this.getDisplayName()}));
        }
        return Deletable.yes();
    }

    protected String[] getParticipations() {
        return DEFAULT_PARTICIPATIONS;
    }

    protected boolean hasParticipations(Entity entity, String[] archetypes) {
        ArchetypeQuery query = new ArchetypeQuery(archetypes, false, false);
        query.add((IConstraint)Constraints.eq((String)"entity", (Object)entity));
        return this.hasMatches(query);
    }

    protected boolean hasEntityLinks(Entity entity) {
        ArchetypeQuery query = new ArchetypeQuery("entityLink.*", false, false);
        query.add((IConstraint)Constraints.eq((String)"target", (Object)entity));
        return this.hasMatches(query);
    }

    protected boolean hasMatches(Entity entity, String[] exclude) {
        boolean result = false;
        if (exclude == null || exclude.length == 0) {
            result = !entity.getSourceEntityRelationships().isEmpty();
        } else {
            for (Relationship relationship : entity.getSourceEntityRelationships()) {
                if (relationship.isA(exclude)) continue;
                result = true;
                break;
            }
        }
        if (!result) {
            result = this.hasEntityLinks(entity);
        }
        return result;
    }
}

