/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.customer;

import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IdConstraint;
import org.openvpms.component.system.common.query.JoinConstraint;
import org.openvpms.component.system.common.query.ObjectSelectConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.ShortNameConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.query.AbstractEntityResultSet;
import org.openvpms.web.component.im.query.ObjectSetQueryExecutor;

public class CustomerResultSet
extends AbstractEntityResultSet<ObjectSet> {
    private final String patient;
    private final String contact;

    public CustomerResultSet(ShortNameConstraint archetypes, String value, boolean searchIdentities, String patient, String contact, IConstraint constraints, SortConstraint[] sort, int rows, boolean distinct) {
        super(archetypes, value, searchIdentities, constraints, sort, rows, distinct, new ObjectSetQueryExecutor());
        archetypes.setAlias("customer");
        this.patient = patient;
        this.contact = contact;
    }

    public boolean isSearchingOnPatient() {
        return !StringUtils.isEmpty((CharSequence)this.patient);
    }

    public boolean isSearchingOnContact() {
        return !StringUtils.isEmpty((CharSequence)this.contact);
    }

    @Override
    protected ArchetypeQuery createQuery() {
        ArchetypeQuery query = super.createQuery();
        query.add((IConstraint)new ObjectSelectConstraint("customer"));
        if (this.isSearchingOnPatient()) {
            query.add((IConstraint)Constraints.shortName((String)"patient", (String)"party.patientpet"));
            JoinConstraint join = Constraints.join((String)"patients");
            boolean activeOnly = this.getArchetypes().isActiveOnly();
            if (activeOnly) {
                Date now = new Date();
                join.add((IConstraint)Constraints.lte((String)"activeStartTime", (Object)now));
                join.add((IConstraint)Constraints.or((IConstraint[])new IConstraint[]{Constraints.gt((String)"activeEndTime", (Object)now), Constraints.isNull((String)"activeEndTime")}));
            }
            join.add((IConstraint)new IdConstraint("source", "customer"));
            join.add((IConstraint)new IdConstraint("target", "patient"));
            query.add((IConstraint)join);
            Long id = this.getId(this.patient);
            if (id != null) {
                query.add((IConstraint)Constraints.eq((String)"patient.id", (Object)id));
            } else {
                query.add((IConstraint)Constraints.eq((String)"patient.name", (Object)this.patient));
            }
            if (activeOnly) {
                query.add((IConstraint)Constraints.eq((String)"patient.active", (Object)true));
            } else if (query.getArchetypeConstraint().getState() == BaseArchetypeConstraint.State.INACTIVE) {
                query.add((IConstraint)Constraints.eq((String)"patient.active", (Object)false));
            }
            query.add((IConstraint)new ObjectSelectConstraint("patient"));
        }
        if (this.isSearchingOnContact()) {
            query.add((IConstraint)Constraints.join((String)"contacts", (String)"contact").add((IConstraint)Constraints.eq((String)"description", (Object)this.contact)));
            query.add((IConstraint)new ObjectSelectConstraint("contact"));
        }
        if (this.isSearchingIdentities()) {
            query.add((IConstraint)new ObjectSelectConstraint("identity"));
        }
        return query;
    }
}

