/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.customer;

import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.alert.MandatoryAlerts;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.ContextHelper;
import org.openvpms.web.component.im.customer.CustomerBrowser;
import org.openvpms.web.component.im.customer.CustomerReferenceEditor;
import org.openvpms.web.component.im.edit.IMObjectReferenceEditor;
import org.openvpms.web.component.im.edit.act.ParticipationEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.patient.PatientParticipationEditor;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.property.Property;

public class CustomerParticipationEditor
extends ParticipationEditor<Party> {
    private final MandatoryAlerts alerts;
    private PatientParticipationEditor patientEditor;

    public CustomerParticipationEditor(Participation participation, Act parent, LayoutContext layout) {
        super(participation, parent, layout);
        if (!TypeHelper.isA((IMObject)participation, (String)"participation.customer")) {
            throw new IllegalArgumentException("Invalid participation type:" + participation.getArchetype());
        }
        Context context = this.getLayoutContext().getContext();
        this.alerts = new MandatoryAlerts(context, layout.getHelpContext());
        Reference customerRef = participation.getEntity();
        if (customerRef == null && parent.isNew()) {
            Party customer = context.getCustomer();
            this.setEntity(customer);
        } else {
            Party customer = (Party)this.getObject(customerRef);
            if (customer != null && customer != context.getCustomer()) {
                ContextHelper.setCustomer(context, customer);
            }
        }
    }

    public void setPatientParticipationEditor(PatientParticipationEditor editor) {
        this.patientEditor = editor;
        if (this.patientEditor != null) {
            this.patientEditor.setCustomerParticipationEditor(this);
        }
    }

    public void showAlerts() {
        this.alerts.show((Party)this.getEntity());
    }

    @Override
    protected IMObjectReferenceEditor<Party> createEntityEditor(Property property) {
        LayoutContext context = this.getLayoutContext();
        DefaultLayoutContext subContext = new DefaultLayoutContext(context, context.getHelpContext().topic("customer"));
        return new CustomerReferenceEditor(property, this.getParent(), subContext, true){

            @Override
            protected void onSelected(Party object) {
                super.onSelected(object);
                CustomerParticipationEditor.this.alerts.show(object);
            }

            @Override
            protected void onSelected(Party object, Browser<Party> browser) {
                Party patient;
                super.onSelected(object, browser);
                CustomerParticipationEditor.this.alerts.show(object);
                if (CustomerParticipationEditor.this.patientEditor != null && browser instanceof CustomerBrowser && (patient = ((CustomerBrowser)browser).getPatient()) != null) {
                    CustomerParticipationEditor.this.patientEditor.setEntity(patient);
                    CustomerParticipationEditor.this.patientEditor.showAlerts();
                }
            }
        };
    }
}

