/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.contact;

import java.util.Objects;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.web.component.im.contact.AbstractContactEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.system.ServiceHelper;

public class LocationEditor
extends AbstractContactEditor {
    private final LookupService lookups = ServiceHelper.getLookupService();
    private final Property suburb = this.getProperty("suburb");
    private final Property state;

    public LocationEditor(IMObject object, IMObject parent, LayoutContext layoutContext) {
        super(object, parent, layoutContext);
        this.suburb.addModifiableListener(modifiable -> this.onSuburbChanged());
        this.state = this.getProperty("state");
        this.state.addModifiableListener(modifiable -> this.onStateChanged());
    }

    protected void onSuburbChanged() {
        Property postCode = this.getProperty("postcode");
        Lookup lookup = this.getSuburb();
        if (lookup != null) {
            IMObjectBean bean = this.getBean((IMObject)lookup);
            postCode.setValue(bean.getValue("postCode"));
            Lookup stateLookup = (Lookup)bean.getSource("target", Lookup.class);
            this.state.setValue(stateLookup != null ? stateLookup.getCode() : null);
        } else {
            postCode.setValue(null);
        }
    }

    protected void onStateChanged() {
        Lookup stateLookup = this.getState();
        Lookup suburbLookup = this.getSuburb();
        if (suburbLookup != null && stateLookup != null && !Objects.equals(this.getState(suburbLookup), stateLookup)) {
            this.suburb.setValue(null);
        }
    }

    private Lookup getSuburb() {
        String code = this.suburb.getString();
        return code != null ? this.lookups.getLookup("lookup.suburb", code, false) : null;
    }

    private Lookup getState() {
        String code = this.getProperty("state").getString();
        return code != null ? this.lookups.getLookup("lookup.state", code, false) : null;
    }

    private Lookup getState(Lookup suburb) {
        IMObjectBean bean = this.getBean((IMObject)suburb);
        return (Lookup)bean.getSource("target", Lookup.class);
    }
}

