/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.contact;

import nextapp.echo2.app.Button;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.contact.ContactHelper;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.mail.MailDialog;
import org.openvpms.web.component.mail.MailDialogFactory;
import org.openvpms.web.component.mail.ToAddressFormatter;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class EmailLauncher {
    private final String address;
    private final Contact email;
    private final Context context;
    private final HelpContext help;
    private final MailContext mailContext;
    private int length = -1;

    private EmailLauncher(String address, Contact email, Context context, HelpContext help, MailContext mailContext) {
        this.address = address;
        this.email = email;
        this.context = context;
        this.help = help.topic("email");
        this.mailContext = mailContext;
    }

    public void setEmailLength(int length) {
        if (length > 5) {
            this.length = length;
        }
    }

    public Button getWriteButton() {
        String text;
        Button button = ButtonFactory.create(null, (String)"hyperlink", () -> {
            MailDialogFactory factory = ServiceHelper.getBean(MailDialogFactory.class);
            MailDialog dialog = factory.create(this.mailContext, this.email, new DefaultLayoutContext(this.context, this.help));
            dialog.show();
        });
        button.setToolTipText(Messages.get((String)"mail.internal.tooltip"));
        if (this.length > 0 && this.address.length() > this.length) {
            text = StringUtils.abbreviateMiddle((String)this.address, (String)"...", (int)this.length);
            button.setToolTipText(this.address);
        } else {
            text = this.address;
        }
        button.setText(text);
        return button;
    }

    public Component getMailToLink() {
        Label html = null;
        boolean showMailTo = false;
        Party practice = this.context.getPractice();
        if (practice != null) {
            IMObjectBean bean = ServiceHelper.getArchetypeService().getBean((IMObject)practice);
            showMailTo = bean.getBoolean("showMailTo");
        }
        if (showMailTo) {
            ToAddressFormatter formatter = new ToAddressFormatter();
            String escaped = StringEscapeUtils.escapeXml11((String)("<" + this.address + ">"));
            String name = StringEscapeUtils.escapeXml11((String)formatter.getName(this.email));
            String uri = "../images/buttons/external-link.png";
            html = LabelFactory.html((String)("<a href=\"mailto:" + name + escaped + "\"><img src=\"" + uri + "\"/></a>"));
            html.setToolTipText(Messages.get((String)"mail.external.tooltip"));
        }
        return html;
    }

    public static EmailLauncher create(Party party, ArchetypeService service, Context context, HelpContext help, MailContext mailContext) {
        Contact email = ContactHelper.getPreferredEmail(party, service);
        if (email != null) {
            return EmailLauncher.create(email, service, context, help, mailContext);
        }
        return null;
    }

    public static EmailLauncher create(Contact email, ArchetypeService service, Context context, HelpContext help, MailContext mailContext) {
        String address = ContactHelper.getEmail(email, service);
        if (address != null) {
            return new EmailLauncher(address, email, context, help, mailContext);
        }
        return null;
    }
}

