/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.clinician;

import nextapp.echo2.app.Component;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.user.User;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.clinician.ClinicianQuery;
import org.openvpms.web.component.im.edit.AbstractIMObjectReferenceEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.util.UserHelper;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.echo.focus.FocusHelper;

public class ClinicianReferenceEditor
extends AbstractIMObjectReferenceEditor<User> {
    public ClinicianReferenceEditor(Property property, IMObject parent, LayoutContext context) {
        super(property, parent, context);
    }

    @Override
    public boolean setObject(User object) {
        Context context = this.getLayoutContext().getContext();
        if (!UserHelper.useLoggedInClinician(context) && (object == null || object.isActive())) {
            context.setClinician(object);
        }
        return super.setObject(object);
    }

    @Override
    protected Query<User> createQuery(String name) {
        ClinicianQuery query = new ClinicianQuery(this.getProperty().getArchetypeRange(), this.getContext());
        query.setValue(name);
        return query;
    }

    @Override
    protected boolean isValidReference(Reference reference) {
        ClinicianQuery query = new ClinicianQuery(this.getContext());
        Component focus = FocusHelper.getFocus();
        query.getComponent();
        query.setAllLocations(true);
        query.setActive(BaseArchetypeConstraint.State.BOTH);
        if (focus != null) {
            FocusHelper.setFocus((Component)focus);
        }
        return query.selects(reference);
    }
}

