/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.clinician;

import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.im.clinician.ClinicianReferenceEditor;
import org.openvpms.web.component.im.edit.IMObjectReferenceEditor;
import org.openvpms.web.component.im.edit.act.ParticipationEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.Property;

public class ClinicianParticipationEditor
extends ParticipationEditor<User> {
    public ClinicianParticipationEditor(Participation participation, Act parent, LayoutContext context) {
        super(participation, parent, context);
        User clinician;
        if (!TypeHelper.isA((IMObject)participation, (String)"participation.clinician")) {
            throw new IllegalArgumentException("Invalid participation type:" + participation.getArchetype());
        }
        if (participation.getEntity() == null && parent.isNew() && (clinician = this.getLayoutContext().getContext().getClinician()) != null && clinician.isActive()) {
            this.setEntity(clinician);
        }
    }

    @Override
    protected IMObjectReferenceEditor<User> createEntityEditor(Property property) {
        LayoutContext context = this.getLayoutContext();
        DefaultLayoutContext subContext = new DefaultLayoutContext(context, context.getHelpContext().topic("clinician"));
        return new ClinicianReferenceEditor(property, this.getParent(), subContext);
    }
}

