/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.archetype;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.system.ServiceHelper;

public class Archetypes<T extends IMObject> {
    private final Class<T> type;
    private final String defaultShortName;
    private final String[] shortNames;
    private String displayName;

    public Archetypes(String shortName, Class<T> type) {
        this(shortName, type, null);
    }

    public Archetypes(String shortName, Class<T> type, String displayName) {
        this(new String[]{shortName}, type, null, displayName);
    }

    public Archetypes(String[] shortNames, Class<T> type, String defaultShortName, String displayName) {
        this.shortNames = Archetypes.expandArchetypes(shortNames);
        Class<?> actual = IMObjectHelper.getType(this.shortNames);
        if (!type.isAssignableFrom(actual)) {
            throw new IllegalStateException("Invalid type. Expected " + type + ", but got " + actual + " for archetypes " + StringUtils.join((Object[])shortNames, (String)", "));
        }
        this.type = type;
        this.defaultShortName = defaultShortName;
        this.displayName = displayName;
    }

    public Archetypes(String[] shortNames, Class<T> type) {
        this(shortNames, type, null, null);
    }

    public String[] getShortNames() {
        return this.shortNames;
    }

    public String getDefaultShortName() {
        return this.defaultShortName;
    }

    public boolean contains(String shortName) {
        for (String s : this.shortNames) {
            if (!TypeHelper.matches((String)s, (String)shortName)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(IMObject object) {
        return this.contains(object.getArchetype());
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            this.displayName = this.createDisplayName();
        }
        return this.displayName;
    }

    public Class<T> getType() {
        return this.type;
    }

    public boolean equals(Object obj) {
        boolean result = super.equals(obj);
        if (!result && obj instanceof Archetypes) {
            Archetypes other = (Archetypes)obj;
            if (this.type.equals(other.type) && this.shortNames.length == other.shortNames.length) {
                Object[] archetypes1 = Arrays.copyOf(this.shortNames, this.shortNames.length);
                Object[] archetypes2 = Arrays.copyOf(other.shortNames, other.shortNames.length);
                Arrays.sort(archetypes1);
                Arrays.sort(archetypes2);
                result = Arrays.equals(archetypes1, archetypes2);
            }
        }
        return result;
    }

    public static <T extends IMObject> Archetypes<T> create(String shortName, Class<T> type) {
        return new Archetypes<T>(shortName, type);
    }

    public static <T extends IMObject> Archetypes<T> create(String shortName, Class<T> type, String displayName) {
        return new Archetypes<T>(shortName, type, displayName);
    }

    public static <T extends IMObject> Archetypes<T> create(Collection<String> archetypes, Class<T> type) {
        return Archetypes.create(archetypes.toArray(new String[0]), type);
    }

    public static <T extends IMObject> Archetypes<T> create(String[] shortNames, Class<T> type) {
        return new Archetypes<T>(shortNames, type);
    }

    public static <T extends IMObject> Archetypes<T> create(String[] shortNames, Class<T> type, String displayName) {
        return Archetypes.create(shortNames, type, null, displayName);
    }

    public static <T extends IMObject> Archetypes<T> create(String[] shortNames, Class<T> type, String defaultShortName, String displayName) {
        return new Archetypes<T>(shortNames, type, defaultShortName, displayName);
    }

    public static <T extends IMObject> Archetypes<T> create(String[] archetypes, String[] exclude, Class<T> type, String defaultArchetype, String displayName) {
        archetypes = Archetypes.expandArchetypes(archetypes);
        if ((exclude = Archetypes.expandArchetypes(exclude)).length > 0) {
            archetypes = (String[])ArrayUtils.removeElements((Object[])archetypes, (Object[])exclude);
        }
        return new Archetypes<T>(archetypes, type, defaultArchetype, displayName);
    }

    protected String createDisplayName() {
        StringBuilder type = new StringBuilder();
        IArchetypeRuleService service = ServiceHelper.getArchetypeService();
        for (int i = 0; i < this.shortNames.length && i < 2; ++i) {
            if (i != 0) {
                type.append("/");
            }
            type.append(DescriptorHelper.getDisplayName((String)this.shortNames[i], (ArchetypeService)service));
        }
        if (this.shortNames.length > 2) {
            type.append("/...");
        }
        return type.toString();
    }

    private static String[] expandArchetypes(String[] shortNames) {
        IArchetypeRuleService service = ServiceHelper.getArchetypeService();
        String[] result = DescriptorHelper.getShortNames((String[])shortNames, (ArchetypeService)service);
        if (result.length == 0) {
            for (String shortName : shortNames) {
                if (!shortName.contains("*")) continue;
                return result;
            }
            result = DescriptorHelper.getShortNames((String[])shortNames, (boolean)false, (ArchetypeService)service);
        }
        return result;
    }
}

