/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.act;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.mutable.MutableObject;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.action.ActionFactory;
import org.openvpms.web.component.action.ObjectCallBuilder;
import org.openvpms.web.system.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintedFlagUpdater {
    private final List<String> finalStatuses;
    private final ActionFactory factory;
    private final ArchetypeService service;
    private static final String PRINTED = "printed";
    private static final Logger log = LoggerFactory.getLogger(PrintedFlagUpdater.class);

    public PrintedFlagUpdater() {
        this("POSTED", "CANCELLED");
    }

    public PrintedFlagUpdater(String ... finalStatuses) {
        this.finalStatuses = Arrays.asList(finalStatuses);
        this.factory = ServiceHelper.getBean(ActionFactory.class);
        this.service = ServiceHelper.getArchetypeService(false);
    }

    public <T extends Act> T setPrinted(T act) {
        MutableObject result = new MutableObject();
        ((ObjectCallBuilder)((ObjectCallBuilder)this.factory.newAction().backgroundOnly().withObject(act).useLatestInstanceOnRetry()).skipIfMissing()).call(obj -> {
            if (this.canUpdate((Act)obj) && this.update((Act)obj)) {
                this.service.save((IMObject)obj);
                result.setValue(obj);
            }
        }).onFailure(status -> log.warn("Failed to set printed flag: {}", (Object)status.getReason())).run();
        return (T)((Act)result.getValue());
    }

    protected boolean canUpdate(Act act) {
        return !this.isFinancial(act) || this.isFinalStatus(act);
    }

    protected boolean isFinalStatus(Act act) {
        String status = act.getStatus();
        return status != null && this.finalStatuses.contains(status);
    }

    protected boolean update(Act act) {
        boolean result = false;
        IMObjectBean bean = this.service.getBean((IMObject)act);
        if (bean.hasNode(PRINTED) && !bean.getBoolean(PRINTED)) {
            bean.setValue(PRINTED, (Object)true);
            result = true;
        }
        return result;
    }

    private boolean isFinancial(Act act) {
        return act instanceof FinancialAct || act.isA("act.customerEstimation");
    }
}

