/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.act;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.collections.Predicate;
import org.openvpms.component.model.act.Act;
import org.openvpms.web.component.im.act.ActHierarchyFilter;
import org.openvpms.web.component.im.act.ActHierarchyLister;

public class ActHierarchyIterator<T extends Act>
implements Iterable<T> {
    private final Iterable<T> acts;
    private final ActHierarchyFilter<T> filter;
    private final int maxDepth;

    public ActHierarchyIterator(Iterable<T> acts) {
        this(acts, (Predicate)null, -1);
    }

    public ActHierarchyIterator(Iterable<T> acts, String[] archetypes) {
        this(acts, archetypes, true, -1);
    }

    public ActHierarchyIterator(Iterable<T> acts, String[] archetypes, int maxDepth) {
        this(acts, archetypes, true, maxDepth);
    }

    public ActHierarchyIterator(Iterable<T> acts, String[] archetypes, boolean include, int maxDepth) {
        this(acts, new ActHierarchyFilter(archetypes, include), maxDepth);
    }

    public ActHierarchyIterator(Iterable<T> acts, Predicate predicate, int maxDepth) {
        this(acts, new ActHierarchyFilter(predicate), maxDepth);
    }

    public ActHierarchyIterator(Iterable<T> acts, ActHierarchyFilter<T> filter, int maxDepth) {
        this.acts = acts;
        this.filter = filter;
        this.maxDepth = maxDepth;
    }

    @Override
    public Iterator<T> iterator() {
        return new ActIterator(this.maxDepth);
    }

    protected ActHierarchyFilter<T> getFilter() {
        return this.filter;
    }

    protected List<T> flattenTree(T root) {
        ActHierarchyLister<T> flattener = new ActHierarchyLister<T>();
        return flattener.list(root, this.filter, this.maxDepth);
    }

    private class ActIterator
    implements Iterator<T> {
        private final Iterator<T> parent;
        private final int maxDepth;
        private Iterator<T> child;
        private T current;

        ActIterator(int maxDepth) {
            this.maxDepth = maxDepth;
            this.parent = ActHierarchyIterator.this.acts.iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.current == null) {
                this.advance();
            }
            return this.current != null;
        }

        @Override
        public T next() {
            if (this.current == null && !this.advance()) {
                throw new NoSuchElementException();
            }
            Object result = this.current;
            this.current = null;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private boolean advance() {
            this.current = null;
            while (this.child == null || !this.child.hasNext()) {
                if (this.parent.hasNext()) {
                    Act root = (Act)this.parent.next();
                    if (this.maxDepth == -1 || this.maxDepth > 1) {
                        this.child = ActHierarchyIterator.this.flattenTree(root).iterator();
                        continue;
                    }
                    this.child = Collections.singletonList(root).iterator();
                    continue;
                }
                return false;
            }
            this.current = (Act)this.child.next();
            return true;
        }
    }
}

