/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.error;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.mail.internet.MimeMessage;
import org.apache.commons.codec.binary.Base64;
import org.openvpms.web.component.error.ErrorReport;
import org.openvpms.web.component.error.ErrorReporterConfig;
import org.openvpms.web.component.error.ThrowableAdapter;
import org.openvpms.web.component.service.PracticeMailService;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamSource;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;

public class ErrorReporter {
    private final ErrorReporterConfig config;
    private String to = "ZXJyb3ItcmVwb3J0c0BsaXN0cy5vcGVudnBtcy5vcmc=";
    private Logger log = LoggerFactory.getLogger(ErrorReporter.class);
    private static final String RESOURCE = "/ErrorReporter.xml";

    public ErrorReporter() {
        InputStream stream = this.getClass().getResourceAsStream(RESOURCE);
        if (stream == null) {
            throw new IllegalStateException("Failed to find error reporter configuration:/ErrorReporter.xml");
        }
        this.config = ErrorReporterConfig.read(stream);
        this.to = new String(Base64.decodeBase64((String)this.to));
    }

    public void report(ErrorReport report, String from) {
        try {
            JavaMailSender sender = ServiceHelper.getBean(PracticeMailService.class);
            MimeMessage message = sender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(message, true);
            String subject = report.getVersion() + ": " + report.getMessage();
            helper.setSubject(subject);
            helper.setFrom(from);
            helper.setTo(this.to);
            String text = this.getText(report);
            if (text != null) {
                helper.setText(text);
            }
            InputStreamSource source = () -> new ByteArrayInputStream(report.toXML().getBytes());
            helper.addAttachment("error-report.xml", source, "text/xml");
            sender.send(message);
        }
        catch (Throwable exception) {
            this.log.error(exception.getMessage(), exception);
            ErrorDialog.show((String)Messages.get((String)"errorreportdialog.senderror"));
        }
    }

    public boolean isReportable(Throwable exception) {
        return !this.config.isExcluded(exception);
    }

    private String getText(ErrorReport report) {
        ThrowableAdapter exception = report.getException();
        if (exception != null) {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter((Writer)writer, true);
            exception.printStackTrace(printWriter);
            return writer.getBuffer().toString();
        }
        return null;
    }
}

