/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.error;

import com.thoughtworks.xstream.XStream;
import java.util.Map;
import java.util.stream.Collectors;
import org.openvpms.component.system.common.xstream.XStreamFactory;
import org.openvpms.version.Version;
import org.openvpms.web.component.error.ThrowableAdapter;

class ErrorReport {
    private String version;
    private String revision;
    private String message;
    private ThrowableAdapter exception;
    private long freeMemory;
    private long totalMemory;
    private long maxMemory;
    private Map<String, String> properties;

    public ErrorReport(String message, Throwable exception) {
        this.message = message;
        this.version = Version.VERSION;
        this.revision = Version.REVISION;
        this.exception = exception != null ? new ThrowableAdapter(exception) : null;
        this.freeMemory = Runtime.getRuntime().freeMemory();
        this.totalMemory = Runtime.getRuntime().totalMemory();
        this.maxMemory = Runtime.getRuntime().maxMemory();
        this.properties = System.getProperties().entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> (String)e.getValue()));
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public ThrowableAdapter getException() {
        return this.exception;
    }

    public void setException(ThrowableAdapter exception) {
        this.exception = exception;
    }

    public long getFreeMemory() {
        return this.freeMemory;
    }

    public void setFreeMemory(long freeMemory) {
        this.freeMemory = freeMemory;
    }

    public long getTotalMemory() {
        return this.totalMemory;
    }

    public void setTotalMemory(long totalMemory) {
        this.totalMemory = totalMemory;
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public void setMaxMemory(long maxMemory) {
        this.maxMemory = maxMemory;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public String toXML() {
        XStream stream = XStreamFactory.create((Class[])new Class[]{ErrorReport.class});
        stream.alias("error-report", ErrorReport.class);
        stream.alias("exception", ThrowableAdapter.class);
        return stream.toXML((Object)this);
    }
}

