/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.error;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.service.archetype.ValidationException;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.security.ArchetypeAccessDeniedException;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.archetype.ValidationError;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class ErrorFormatter {
    public static String format(Throwable exception) {
        return ErrorFormatter.format(exception, null);
    }

    public static String formatHTML(Throwable exception) {
        return ErrorFormatter.formatHTML(exception, null);
    }

    public static String format(Throwable exception, String displayName) {
        return ErrorFormatter.format(exception, Category.DEFAULT, displayName);
    }

    public static String formatHTML(Throwable exception, String displayName) {
        return ErrorFormatter.formatHTML(exception, Category.DEFAULT, displayName);
    }

    public static String format(Throwable exception, Category category, String displayName) {
        return ErrorFormatter.formatError(exception, category, displayName, false);
    }

    public static String formatHTML(Throwable exception, Category category, String displayName) {
        return ErrorFormatter.formatError(exception, category, displayName, true);
    }

    private static String formatError(Throwable exception, Category category, String displayName, boolean html) {
        Throwable cause;
        String result = null;
        Iterator iterator = ExceptionUtils.getThrowableList((Throwable)exception).iterator();
        while (iterator.hasNext() && (result = ErrorFormatter.formatIfPresent(cause = (Throwable)iterator.next(), category, displayName, html)) == null) {
        }
        if (result == null) {
            result = exception.getLocalizedMessage();
            if (html) {
                result = ErrorFormatter.escape(result);
            }
        }
        if (result == null) {
            result = exception.getClass().getName();
        }
        return result;
    }

    private static String formatIfPresent(Throwable exception, Category category, String displayName, boolean html) {
        String result = null;
        String className = exception.getClass().getName();
        String message = exception.getMessage();
        if (html && message != null) {
            message = StringEscapeUtils.escapeHtml4((String)message);
        }
        if (exception instanceof ArchetypeAccessDeniedException) {
            result = ErrorFormatter.formatAccessDeniedException((ArchetypeAccessDeniedException)exception, html);
        } else if (exception instanceof ValidationException) {
            result = ErrorFormatter.formatValidationException((ValidationException)exception, html);
        } else if (displayName != null) {
            String cat = category == Category.DEFAULT ? "" : "." + category.toString().toLowerCase();
            result = ErrorFormatter.formatIfPresent(className + cat + ".displayName", html, message, displayName);
        }
        if (result == null) {
            result = ErrorFormatter.formatIfPresent(className, html, message);
        }
        return result;
    }

    private static String formatAccessDeniedException(ArchetypeAccessDeniedException exception, boolean html) {
        String archetype = DescriptorHelper.getDisplayName((String)exception.getArchetype(), (ArchetypeService)ServiceHelper.getArchetypeService());
        if (archetype == null) {
            archetype = exception.getArchetype();
        }
        return ErrorFormatter.formatIfPresent(exception.getClass().getName(), html, archetype, exception.getOperation());
    }

    private static String formatValidationException(ValidationException exception, boolean html) {
        String result = null;
        List errors = exception.getErrors();
        if (!errors.isEmpty()) {
            ValidationError error = (ValidationError)errors.get(0);
            String archetypeName = null;
            String nodeName = null;
            ArchetypeDescriptor archetype = ServiceHelper.getArchetypeService().getArchetypeDescriptor(error.getArchetype());
            if (archetype != null) {
                archetypeName = archetype.getDisplayName();
                NodeDescriptor descriptor = archetype.getNodeDescriptor(error.getNode());
                if (descriptor != null) {
                    nodeName = descriptor.getDisplayName();
                }
            }
            result = ErrorFormatter.formatIfPresent(error.getClass().getName(), html, archetypeName, nodeName, error.getMessage());
        }
        return result;
    }

    private static String formatIfPresent(String key, boolean html, Object ... args) {
        String result = null;
        if (html) {
            result = Messages.formatNull((String)(key + ".html"), (Object[])args);
        }
        if (result == null) {
            result = Messages.formatNull((String)key, (Object[])args);
            if (html) {
                result = ErrorFormatter.escape(result);
            }
        }
        return result;
    }

    private static String escape(String message) {
        return message != null ? StringEscapeUtils.escapeHtml4((String)message) : null;
    }

    public static enum Category {
        DEFAULT,
        DELETE;

    }
}

