/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.bound;

import java.util.Objects;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.DocumentEvent;
import nextapp.echo2.app.event.DocumentListener;
import org.openvpms.macro.Position;
import org.openvpms.web.component.bound.Binder;
import org.openvpms.web.component.property.NoOpPropertyTransformer;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertyTransformer;
import org.openvpms.web.component.property.StringPropertyTransformer;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.text.TextComponent;

public class TextComponentBinder
extends Binder {
    private final TextComponent component;
    private final org.openvpms.web.echo.event.DocumentListener listener;

    public TextComponentBinder(TextComponent component, Property property) {
        super(property, false);
        this.component = component;
        component.setEnabled(!property.isReadOnly());
        this.listener = new org.openvpms.web.echo.event.DocumentListener(){

            public void onUpdate(DocumentEvent event) {
                TextComponentBinder.this.setProperty();
            }
        };
        this.component.getDocument().addDocumentListener((DocumentListener)this.listener);
        ActionListener actionListener = new ActionListener(){

            public void onAction(ActionEvent event) {
            }
        };
        this.component.addActionListener((nextapp.echo2.app.event.ActionListener)actionListener);
        this.bind();
    }

    @Override
    protected Object getFieldValue() {
        return this.component.getText();
    }

    @Override
    protected void setFieldValue(Object value) {
        this.component.getDocument().removeDocumentListener((DocumentListener)this.listener);
        String text = value != null ? value.toString() : null;
        this.component.setText(text);
        this.component.getDocument().addDocumentListener((DocumentListener)this.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean setProperty(Property property) {
        boolean result;
        Object oldValue;
        Object value = oldValue = this.getFieldValue();
        Position position = null;
        PropertyTransformer transformer = property.getTransformer();
        PropertyTransformer oldTransformer = null;
        if (value instanceof String && transformer instanceof StringPropertyTransformer) {
            try {
                position = new Position(this.component.getCursorPosition());
                value = ((StringPropertyTransformer)transformer).apply(value, position);
                oldTransformer = transformer;
                property.setTransformer(NoOpPropertyTransformer.INSTANCE);
            }
            catch (Throwable ignore) {
                position = null;
            }
        }
        try {
            result = property.setValue(value);
        }
        finally {
            if (oldTransformer != null) {
                property.setTransformer(oldTransformer);
            }
        }
        String newValue = property.getString();
        if (!Objects.equals(oldValue, newValue)) {
            this.setField();
            if (position != null && position.getOldPosition() != position.getNewPosition()) {
                this.component.setCursorPosition(position.getNewPosition());
            }
        }
        return result;
    }
}

