/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.bound;

import echopointng.DateChooser;
import echopointng.DateField;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.Date;
import org.openvpms.web.component.bound.Binder;
import org.openvpms.web.component.property.Property;

public class DateBinder
extends Binder {
    private final DateField field;
    private final PropertyChangeListener listener;

    public DateBinder(DateField field, Property property) {
        super(property, false);
        this.field = field;
        field.setEnabled(!property.isReadOnly());
        this.listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                String name = event.getPropertyName();
                if ("selectedDate".equals(name)) {
                    DateBinder.this.setProperty();
                }
            }
        };
        this.bind();
    }

    protected DateField getField() {
        return this.field;
    }

    @Override
    protected Date getFieldValue() {
        Calendar calendar = this.field.getDateChooser().getSelectedDate();
        return calendar != null ? calendar.getTime() : null;
    }

    @Override
    protected void setFieldValue(Object value) {
        DateChooser chooser = this.field.getDateChooser();
        chooser.removePropertyChangeListener(this.listener);
        Date date = (Date)value;
        Calendar calendar = null;
        if (date != null) {
            calendar = Calendar.getInstance();
            calendar.setTime(date);
        }
        chooser.setSelectedDate(calendar);
        if (calendar != null) {
            chooser.setDisplayedDate(calendar);
        }
        chooser.addPropertyChangeListener(this.listener);
    }
}

