/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.bound;

import java.text.Format;
import java.text.NumberFormat;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Component;
import org.openvpms.web.component.bound.BoundFormattedField;
import org.openvpms.web.component.bound.BoundPasswordField;
import org.openvpms.web.component.bound.BoundTextArea;
import org.openvpms.web.component.bound.BoundTextField;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.util.NumericPropertyFormatter;
import org.openvpms.web.echo.factory.TextComponentFactory;
import org.openvpms.web.echo.text.PasswordField;
import org.openvpms.web.echo.text.TextArea;
import org.openvpms.web.echo.text.TextField;

public class BoundTextComponentFactory
extends TextComponentFactory {
    public static TextField create(Property property, int columns) {
        BoundTextField text = new BoundTextField(property, columns);
        BoundTextComponentFactory.setDefaultStyle((Component)text);
        return text;
    }

    public static TextField create(Property property, int columns, Format format) {
        BoundFormattedField text = new BoundFormattedField(property, columns, format);
        BoundTextComponentFactory.setDefaultStyle((Component)text);
        return text;
    }

    public static TextField createNumeric(Property property, int columns) {
        boolean edit = !property.isReadOnly() && !property.isDerived();
        NumberFormat format = NumericPropertyFormatter.getFormat(property, edit);
        TextField text = BoundTextComponentFactory.create(property, columns, format);
        if (!edit) {
            Alignment align = new Alignment(5, 0);
            text.setAlignment(align);
        }
        return text;
    }

    public static TextArea createTextArea(Property property) {
        BoundTextArea text = new BoundTextArea(property);
        BoundTextComponentFactory.setDefaultStyle((Component)text);
        return text;
    }

    public static TextArea createTextArea(Property property, int columns, int rows) {
        BoundTextArea text = new BoundTextArea(property, columns, rows);
        BoundTextComponentFactory.setDefaultStyle((Component)text);
        return text;
    }

    public static PasswordField createPassword(Property property) {
        BoundPasswordField password = new BoundPasswordField(property);
        BoundTextComponentFactory.setDefaultStyle((Component)password);
        return password;
    }
}

