/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.bound;

import java.text.Format;
import java.text.ParseException;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.text.Document;
import org.openvpms.web.component.bound.Binder;
import org.openvpms.web.component.bound.BoundProperty;
import org.openvpms.web.component.bound.TextComponentBinder;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.echo.text.TextComponent;
import org.openvpms.web.echo.text.TextDocument;
import org.openvpms.web.echo.text.TextField;

public class BoundFormattedField
extends TextField
implements BoundProperty {
    private final Format format;
    private final Binder binder;

    public BoundFormattedField(Property property, Format format) {
        super((Document)new TextDocument());
        this.format = format;
        this.binder = new FormattingBinder((TextComponent)this, property);
    }

    public BoundFormattedField(Property property, int columns, Format format) {
        this(property, format);
        this.setWidth(new Extent(columns, 128));
    }

    public void init() {
        super.init();
        this.binder.bind();
    }

    public void dispose() {
        super.dispose();
        this.binder.unbind();
    }

    @Override
    public Property getProperty() {
        return this.binder.getProperty();
    }

    protected Object parse(String value) {
        Object result = null;
        if (value != null) {
            try {
                result = this.format.parseObject(value);
            }
            catch (ParseException exception) {
                result = value;
            }
        }
        return result;
    }

    protected Format getFormat() {
        return this.format;
    }

    private class FormattingBinder
    extends TextComponentBinder {
        public FormattingBinder(TextComponent component, Property property) {
            super(component, property);
        }

        @Override
        protected Object getFieldValue() {
            String value = (String)super.getFieldValue();
            return BoundFormattedField.this.parse(value);
        }

        @Override
        protected void setFieldValue(Object value) {
            if (value != null) {
                try {
                    value = BoundFormattedField.this.format.format(value);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            super.setFieldValue(value);
        }
    }
}

