/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.bound;

import java.util.Date;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.text.Document;
import org.openvpms.web.component.bound.Binder;
import org.openvpms.web.component.bound.BoundProperty;
import org.openvpms.web.component.bound.TextComponentBinder;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.TimePropertyTransformer;
import org.openvpms.web.echo.text.TextComponent;
import org.openvpms.web.echo.text.TextDocument;
import org.openvpms.web.echo.text.TextField;
import org.openvpms.web.resource.i18n.format.DateFormatter;

public class BoundAbsoluteTimeField
extends TextField
implements BoundProperty {
    private final Binder binder;

    public BoundAbsoluteTimeField(Property property) {
        this(property, true);
    }

    public BoundAbsoluteTimeField(Property property, boolean lessThanMidnight) {
        super((Document)new TextDocument());
        this.setStyleName("default");
        this.binder = new FormattingBinder((TextComponent)this, property);
        if (!(property.getTransformer() instanceof TimePropertyTransformer)) {
            property.setTransformer(new TimePropertyTransformer(property, TimePropertyTransformer.MIN_DATE, TimePropertyTransformer.MAX_DATE, lessThanMidnight));
        }
        this.setAlignment(Alignment.ALIGN_RIGHT);
        this.setWidth(new Extent(5, 128));
    }

    public void init() {
        super.init();
        this.binder.bind();
    }

    public void dispose() {
        super.dispose();
        this.binder.unbind();
    }

    @Override
    public Property getProperty() {
        return this.binder.getProperty();
    }

    private class FormattingBinder
    extends TextComponentBinder {
        public FormattingBinder(TextComponent component, Property property) {
            super(component, property);
        }

        @Override
        protected Object getFieldValue() {
            String value = (String)super.getFieldValue();
            return this.parse(value);
        }

        @Override
        protected void setFieldValue(Object value) {
            if (value instanceof Date) {
                value = DateFormatter.formatTimeDiff((Date)TimePropertyTransformer.MIN_DATE, (Date)((Date)value));
            }
            super.setFieldValue(value);
        }

        protected Object parse(String value) {
            Object result = null;
            if (value != null) {
                try {
                    result = DateFormatter.parseTime((String)value, (boolean)true);
                }
                catch (Throwable exception) {
                    result = value;
                }
            }
            return result;
        }
    }
}

