/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.app;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.DelegatingContext;
import org.openvpms.web.component.im.util.IMObjectHelper;

public class ReloadingContext
extends DelegatingContext {
    private final Set<Reference> reloaded;
    private final boolean reloadAlways;

    public ReloadingContext(Context context) {
        this(context, false);
    }

    public ReloadingContext(Context context, boolean reloadAlways) {
        super(context);
        this.reloadAlways = reloadAlways;
        this.reloaded = !reloadAlways ? new HashSet() : null;
    }

    @Override
    protected <T> T get(Function<Context, T> function) {
        Object result = super.get(function);
        if (result instanceof IMObject) {
            if (this.reloadAlways) {
                result = IMObjectHelper.reload((IMObject)result);
            } else {
                Reference ref = ((IMObject)result).getObjectReference();
                if (!this.reloaded.contains(ref)) {
                    result = IMObjectHelper.reload((IMObject)result);
                    this.reloaded.add(ref);
                }
            }
        }
        return result;
    }
}

