/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.app;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.AbstractContext;
import org.openvpms.web.component.app.ContextHistory;
import org.openvpms.web.component.app.ContextListener;
import org.openvpms.web.component.app.SelectionHistory;

public class GlobalContext
extends AbstractContext
implements ContextHistory {
    private final List<ContextListener> contextListeners = new ArrayList<ContextListener>();
    private final Map<String, List<ContextListener>> archetypeListeners = new HashMap<String, List<ContextListener>>();
    private final Map<String, SelectionHistory> history = new HashMap<String, SelectionHistory>();

    public void addListener(String archetype, ContextListener listener) {
        List listeners = this.archetypeListeners.computeIfAbsent(archetype, k -> new ArrayList());
        listeners.add(listener);
    }

    public void removeListener(String archetype, ContextListener listener) {
        List<ContextListener> listeners = this.archetypeListeners.get(archetype);
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    public void addListener(ContextListener listener) {
        this.contextListeners.add(listener);
    }

    public void removeListener(ContextListener listener) {
        this.contextListeners.remove(listener);
    }

    @Override
    public void setObject(String key, IMObject object) {
        IMObject current = this.getObject(key);
        if (current != object) {
            super.setObject(key, object);
            if (object != null) {
                this.updateHistory(key, object);
            }
            this.notifyListeners(key, object);
        }
    }

    @Override
    public SelectionHistory getHistory(String shortName) {
        SelectionHistory result = this.history.get(shortName);
        return result != null ? result : new SelectionHistory(this);
    }

    public void setHistory(String shortName, SelectionHistory history) {
        this.history.put(shortName, history);
    }

    private void updateHistory(String key, IMObject object) {
        SelectionHistory selectionHistory = this.history.get(key);
        if (selectionHistory == null) {
            selectionHistory = new SelectionHistory(this);
            this.history.put(key, selectionHistory);
        }
        selectionHistory.add(object);
    }

    private void notifyListeners(String key, IMObject value) {
        List<ContextListener> listeners = this.archetypeListeners.get(key);
        if (listeners != null) {
            this.notifyListeners(listeners, key, value);
        }
        this.notifyListeners(this.contextListeners, key, value);
    }

    private void notifyListeners(List<ContextListener> listeners, String key, IMObject value) {
        ContextListener[] list;
        for (ContextListener listener : list = listeners.toArray(new ContextListener[0])) {
            listener.changed(key, value);
        }
    }
}

