/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.security.oauth;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.security.crypto.PasswordEncryptor;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.security.oauth.OAuth2AuthorizedClientServiceImpl;
import org.springframework.security.config.oauth2.client.CommonOAuth2Provider;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2RefreshToken;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;

public class OAuth2AuthorizedClientServiceImplTestCase
extends ArchetypeServiceTest {
    @Test
    public void testService() {
        String registrationId = TestHelper.randomName((String)"gmail");
        ClientRegistration registration = CommonOAuth2Provider.GOOGLE.getBuilder(registrationId).clientId("aclientId").clientSecret("aclientsecret").build();
        PasswordEncryptor encryptor = new PasswordEncryptor(){

            public String encrypt(String password) {
                return password;
            }

            public String decrypt(String encryptedPassword) {
                return encryptedPassword;
            }
        };
        InMemoryClientRegistrationRepository repository = new InMemoryClientRegistrationRepository(new ClientRegistration[]{registration});
        OAuth2AuthorizedClientServiceImpl clientService = new OAuth2AuthorizedClientServiceImpl((ClientRegistrationRepository)repository, (ArchetypeService)this.getArchetypeService(), encryptor);
        String email = "foo@bar.com";
        Assert.assertNull((Object)clientService.loadAuthorizedClient(registrationId, email));
        Date issuedAt1 = TestHelper.getDatetime((String)"2023-01-01 10:01");
        Date issuedAt2 = TestHelper.getDatetime((String)"2023-01-01 10:02");
        Date expiresAt = TestHelper.getDate((String)"2023-01-02");
        OAuth2AccessToken accessToken = new OAuth2AccessToken(OAuth2AccessToken.TokenType.BEARER, "abc123", issuedAt1.toInstant(), expiresAt.toInstant(), new HashSet<String>(Arrays.asList("a", "b")));
        OAuth2RefreshToken refreshToken = new OAuth2RefreshToken("def567", issuedAt2.toInstant());
        OAuth2AuthorizedClient client = new OAuth2AuthorizedClient(registration, email, accessToken, refreshToken);
        clientService.saveAuthorizedClient(client, (Authentication)new PreAuthenticatedAuthenticationToken((Object)email, null));
        OAuth2AuthorizedClient loaded = clientService.loadAuthorizedClient(registrationId, email);
        Assert.assertNotNull((Object)loaded);
        Assert.assertEquals((Object)registration, (Object)loaded.getClientRegistration());
        OAuth2AccessToken loadedAccessToken = loaded.getAccessToken();
        Assert.assertEquals((Object)accessToken.getTokenType(), (Object)loadedAccessToken.getTokenType());
        Assert.assertEquals((Object)accessToken.getTokenValue(), (Object)loadedAccessToken.getTokenValue());
        Assert.assertEquals((Object)accessToken.getScopes(), (Object)loadedAccessToken.getScopes());
        Assert.assertEquals((Object)accessToken.getIssuedAt(), (Object)loadedAccessToken.getIssuedAt());
        Assert.assertEquals((Object)accessToken.getExpiresAt(), (Object)loadedAccessToken.getExpiresAt());
        OAuth2RefreshToken loadedRefreshToken = loaded.getRefreshToken();
        Assert.assertNotNull((Object)loadedRefreshToken);
        Assert.assertEquals((Object)refreshToken.getTokenValue(), (Object)loadedRefreshToken.getTokenValue());
        Assert.assertEquals((Object)refreshToken.getIssuedAt(), (Object)loadedRefreshToken.getIssuedAt());
    }
}

