/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.workflow;

import com.mysql.cj.jdbc.exceptions.MySQLTransactionRollbackException;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.commons.lang3.mutable.MutableObject;
import org.hibernate.exception.LockAcquisitionException;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceBuilder;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.act.DefaultActEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.workflow.DefaultTaskContext;
import org.openvpms.web.component.workflow.DefaultTaskListener;
import org.openvpms.web.component.workflow.EditIMObjectTask;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.component.workflow.TaskEvent;
import org.openvpms.web.component.workflow.TaskListener;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.CannotAcquireLockException;

public class EditIMObjectTaskTestCase
extends AbstractAppTest {
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestCustomerAccountFactory accountFactory;

    @Test
    public void testBackgroundEditFailureCancelsTask() {
        ArrayList<String> errors = new ArrayList<String>();
        this.initErrorHandler(errors);
        EditIMObjectTask task = new EditIMObjectTask("act.customerAccountChargesInvoice", false, false){

            protected IMObjectEditor createEditor(IMObject object, TaskContext context) {
                return new TestChargeEditor((Act)object, this.createLayoutContext(context));
            }

            protected void edit(IMObjectEditor editor, TaskContext context) {
                ((TestChargeEditor)editor).setStatus("POSTED");
            }
        };
        DefaultTaskContext context = new DefaultTaskContext(new HelpContext("foo", null));
        FinancialAct invoice = (FinancialAct)((TestInvoiceBuilder)this.accountFactory.newInvoice().customer(this.customerFactory.createCustomer())).build();
        context.addObject((IMObject)invoice);
        final MutableObject mutableObject = new MutableObject();
        task.addTaskListener((TaskListener)new DefaultTaskListener(){

            public void taskEvent(TaskEvent event) {
                mutableObject.setValue((Object)event);
            }
        });
        task.start((TaskContext)context);
        TaskEvent event = (TaskEvent)mutableObject.getValue();
        Assert.assertNotNull((Object)event);
        Assert.assertEquals((Object)TaskEvent.Type.CANCELLED, (Object)event.getType());
        Assert.assertEquals((long)1L, (long)errors.size());
        Assert.assertEquals((Object)"The Invoice could not be saved due to a deadlock. Please retry the operation.", errors.get(0));
    }

    private static class TestChargeEditor
    extends DefaultActEditor {
        public TestChargeEditor(Act object, LayoutContext context) {
            super(object, null, context);
        }

        public IMObjectEditor newInstance() {
            return new TestChargeEditor((Act)this.reload((IMObject)this.getObject()), this.getLayoutContext());
        }

        protected void doSave() {
            throw new CannotAcquireLockException("could not execute batch", (Throwable)new LockAcquisitionException("could not execute batch", (SQLException)new BatchUpdateException((Throwable)new MySQLTransactionRollbackException("Deadlock found when trying to get lock; try restarting transaction"))));
        }
    }
}

