/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.property;

import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.web.component.property.IntegerPropertyTransformer;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertyException;
import org.openvpms.web.component.property.SimpleProperty;

public class IntegerPropertyTransformerTestCase {
    @Test
    public void testIntegerApply() {
        SimpleProperty property = new SimpleProperty("int", Integer.class);
        IntegerPropertyTransformer handler = new IntegerPropertyTransformer((Property)property);
        Integer one = 1;
        try {
            handler.apply((Object)"abc");
            Assert.fail((String)"expected conversion from 'abc' to fail");
        }
        catch (PropertyException expected) {
            Assert.assertEquals((Object)property, (Object)expected.getProperty());
        }
        Integer int1 = (Integer)handler.apply((Object)"1");
        Assert.assertEquals((Object)one, (Object)int1);
        try {
            handler.apply((Object)"1.0");
            Assert.fail((String)"expected conversion from '1.0' to fail");
        }
        catch (PropertyException expected) {
            Assert.assertEquals((Object)property, (Object)expected.getProperty());
        }
        Assert.assertEquals((Object)one, (Object)handler.apply((Object)new Long(1L)));
        Assert.assertEquals((Object)one, (Object)handler.apply((Object)new BigDecimal(1.0)));
        Assert.assertEquals((Object)one, (Object)handler.apply((Object)new Double(1.5)));
    }

    @Test
    public void testRange() {
        SimpleProperty property = new SimpleProperty("int", Integer.class);
        IntegerPropertyTransformer handler = new IntegerPropertyTransformer((Property)property, -1, 10);
        try {
            handler.apply((Object)"-2");
        }
        catch (PropertyException expected) {
            Assert.assertEquals((Object)property, (Object)expected.getProperty());
            Assert.assertEquals((Object)"Int is less than -1", (Object)expected.getMessage());
        }
        try {
            handler.apply((Object)"11");
        }
        catch (PropertyException expected) {
            Assert.assertEquals((Object)property, (Object)expected.getProperty());
            Assert.assertEquals((Object)"Int is greater than 10", (Object)expected.getMessage());
        }
        Integer int1 = (Integer)handler.apply((Object)"1");
        Assert.assertEquals((Object)new Integer(1), (Object)int1);
        Integer zero = (Integer)handler.apply((Object)0);
        Assert.assertEquals((Object)new Integer(0), (Object)zero);
    }

    @Test
    public void testOptionalInteger() {
        SimpleProperty property = new SimpleProperty("count", Integer.class);
        property.setRequired(false);
        IntegerPropertyTransformer handler = new IntegerPropertyTransformer((Property)property, Integer.valueOf(0), null);
        Assert.assertNull((Object)handler.apply((Object)""));
        Assert.assertNull((Object)handler.apply(null));
        try {
            handler.apply((Object)"-1");
        }
        catch (PropertyException expected) {
            Assert.assertEquals((Object)property, (Object)expected.getProperty());
            Assert.assertEquals((Object)"Count is less than 0", (Object)expected.getMessage());
        }
        Assert.assertEquals((Object)1, (Object)handler.apply((Object)"1"));
    }
}

