/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.mail;

import com.google.common.base.Charsets;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.openvpms.archetype.rules.doc.EmailTemplate;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.doc.TestDocumentBuilder;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.doc.TestEmailTemplateBuilder;
import org.openvpms.archetype.test.builder.lookup.TestLookupFactory;
import org.openvpms.archetype.test.builder.patient.TestPatientBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.macro.Macros;
import org.openvpms.report.DocumentConverter;
import org.openvpms.report.ReportFactory;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.mail.EmailTemplateEvaluator;
import org.openvpms.web.test.AbstractAppTest;
import org.springframework.beans.factory.annotation.Autowired;

public class EmailTemplateEvaluatorTestCase
extends AbstractAppTest {
    @Autowired
    private Macros macros;
    @Autowired
    private ReportFactory reportFactory;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestDocumentFactory documentFactory;
    @Autowired
    private TestLookupFactory lookupFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    private EmailTemplateEvaluator evaluator;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        DocumentConverter converter = (DocumentConverter)Mockito.mock(DocumentConverter.class);
        this.evaluator = new EmailTemplateEvaluator((ArchetypeService)this.getArchetypeService(), this.getLookupService(), this.macros, this.reportFactory, converter);
    }

    @Test
    public void testPlainText() {
        EmailTemplate template = this.createTemplate(EmailTemplate.SubjectType.TEXT, "Plain text subject &", EmailTemplate.ContentType.TEXT, "Plain\ntext\ncontent &");
        String subject = this.evaluator.getSubject(template, new Object(), (Context)new LocalContext());
        String message = this.evaluator.getMessage(template, new Object(), (Context)new LocalContext());
        Assert.assertEquals((Object)"Plain text subject &", (Object)subject);
        Assert.assertEquals((Object)"Plain<br/>text<br/>content &amp;", (Object)message);
    }

    @Test
    public void testMacro() {
        this.lookupFactory.getMacro("@cpname", "concat($customer.firstName, ' & ', $patient.name)");
        Party customer = (Party)this.customerFactory.newCustomer().name("Sue", "Smith").build(false);
        Party patient = (Party)((TestPatientBuilder)this.patientFactory.newPatient().name("Fido")).owner(customer).build(false);
        EmailTemplate template = this.createTemplate(EmailTemplate.SubjectType.MACRO, "Reminder for @cpname", EmailTemplate.ContentType.MACRO, "Dear @cpname\nplease");
        LocalContext context = new LocalContext();
        context.setCustomer(customer);
        context.setPatient(patient);
        String subject = this.evaluator.getSubject(template, new Object(), (Context)context);
        String message = this.evaluator.getMessage(template, new Object(), (Context)context);
        Assert.assertEquals((Object)"Reminder for Sue & Fido", (Object)subject);
        Assert.assertEquals((Object)"Dear Sue &amp; Fido<br/>please", (Object)message);
    }

    @Test
    public void testXPath() {
        Party customer = (Party)this.customerFactory.newCustomer().name("Sue", "Smith").build(false);
        Party patient = (Party)((TestPatientBuilder)this.patientFactory.newPatient().name("Fido")).owner(customer).build(false);
        EmailTemplate template = this.createTemplate(EmailTemplate.SubjectType.XPATH, "concat('Reminder for ', $customer.firstName, ' & ', $patient.name)", EmailTemplate.ContentType.XPATH, "concat('Dear ', $customer.firstName, ' & ', $patient.name,$nl,'please')");
        LocalContext context = new LocalContext();
        context.setCustomer(customer);
        context.setPatient(patient);
        String subject = this.evaluator.getSubject(template, new Object(), (Context)context);
        String message = this.evaluator.getMessage(template, new Object(), (Context)context);
        Assert.assertEquals((Object)"Reminder for Sue & Fido", (Object)subject);
        Assert.assertEquals((Object)"Dear Sue &amp; Fido<br/>please", (Object)message);
    }

    @Test
    public void testStaticHTML() {
        Document html = (Document)((TestDocumentBuilder)this.documentFactory.newDocument().name("test.html")).content("<html><body>some html text</body></html>").mimeType("text/html").build();
        Entity entity = (Entity)this.documentFactory.newEmailTemplate("entity.documentTemplateEmailSystem").subject("Reminder").document(html).build();
        EmailTemplate template = new EmailTemplate(entity, (ArchetypeService)this.getArchetypeService());
        String subject = this.evaluator.getSubject(template, new Object(), (Context)new LocalContext());
        String message = this.evaluator.getMessage(template, new Object(), (Context)new LocalContext());
        Assert.assertEquals((Object)"Reminder", (Object)subject);
        Assert.assertEquals((Object)"<html><body>some html text</body></html>", (Object)message);
    }

    @Test
    public void testJasperReport() throws Exception {
        Entity entity = (Entity)((TestEmailTemplateBuilder)this.documentFactory.newEmailTemplate("entity.documentTemplateEmailSystem").subject("Reminder").contentSource("$customer").document("/EmailTemplateEvaluator.jrxml", "text/xml")).build();
        EmailTemplate template = new EmailTemplate(entity, (ArchetypeService)this.getArchetypeService());
        Party customer = (Party)this.customerFactory.newCustomer().name("Joe", "Smith").build(false);
        LocalContext context = new LocalContext();
        context.setCustomer(customer);
        String subject = this.evaluator.getSubject(template, new Object(), (Context)context);
        String message = this.evaluator.getMessage(template, new Object(), (Context)context);
        Assert.assertEquals((Object)"Reminder", (Object)subject);
        try (InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream("/EmailTemplateEvaluator.expected.html");){
            Assert.assertNotNull((Object)stream);
            String expected = IOUtils.toString((InputStream)stream, (Charset)Charsets.UTF_8);
            expected = expected.replaceAll("\r\n", "\n");
            Assert.assertEquals((Object)expected, (Object)message);
        }
    }

    @Test
    public void testSubjectSource() {
        Entity entity = (Entity)this.documentFactory.newEmailTemplate("entity.documentTemplateEmailSystem").subject("concat('Statement: ', openvpms:get(., 'firstName'), ' ', openvpms:get(., 'lastName'))").subjectType(EmailTemplate.SubjectType.XPATH).subjectSource("$customer").build();
        EmailTemplate template = new EmailTemplate(entity, (ArchetypeService)this.getArchetypeService());
        Party customer = (Party)this.customerFactory.newCustomer().name("Joe", "Smith").build(false);
        LocalContext context = new LocalContext();
        context.setCustomer(customer);
        String subject = this.evaluator.getSubject(template, new Object(), (Context)context);
        Assert.assertEquals((Object)"Statement: Joe Smith", (Object)subject);
    }

    @Test
    public void testContentSource() {
        Entity entity = (Entity)this.documentFactory.newEmailTemplate("entity.documentTemplateEmailSystem").subject("Your statement").content("concat('Dear ', openvpms:get(., 'firstName'), ' ', openvpms:get(., 'lastName'))").contentType(EmailTemplate.ContentType.XPATH).contentSource("$customer").build();
        EmailTemplate template = new EmailTemplate(entity, (ArchetypeService)this.getArchetypeService());
        Party customer = (Party)this.customerFactory.newCustomer().name("Jo", "Smith").build(false);
        LocalContext context = new LocalContext();
        context.setCustomer(customer);
        String content = this.evaluator.getMessage(template, new Object(), (Context)context);
        Assert.assertEquals((Object)"Dear Jo Smith", (Object)content);
    }

    private EmailTemplate createTemplate(EmailTemplate.SubjectType subjectType, String subject, EmailTemplate.ContentType contentType, String content) {
        Entity entity = (Entity)this.documentFactory.newEmailTemplate("entity.documentTemplateEmailSystem").subjectType(subjectType).subject(subject).contentType(contentType).content(content).build();
        return new EmailTemplate(entity, (ArchetypeService)this.getArchetypeService());
    }
}

