/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.report;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.archetype.rules.doc.TemplateHelper;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.doc.TestDocumentTemplateBuilder;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.report.DocumentTemplateLocator;
import org.openvpms.web.component.im.report.DocumentTemplateLocatorFactory;
import org.openvpms.web.component.im.report.InvestigationTemplateLocator;
import org.springframework.beans.factory.annotation.Autowired;

public class InvestigationTemplateLocatorTestCase
extends ArchetypeServiceTest {
    @Autowired
    private TestDocumentFactory documentFactory;

    @Test
    public void testGetTemplate() {
        TemplateHelper helper = new TemplateHelper((ArchetypeService)this.getArchetypeService());
        Entity entity = helper.getTemplateForType("act.patientInvestigation");
        if (entity == null) {
            entity = (Entity)((TestDocumentTemplateBuilder)this.documentFactory.newTemplate().type("act.patientInvestigation").blankDocument()).build();
        }
        InvestigationTemplateLocator locator = new InvestigationTemplateLocator((ArchetypeService)this.getArchetypeService());
        DocumentTemplate template = locator.getTemplate();
        Assert.assertNotNull((Object)template);
        Assert.assertEquals((Object)entity, (Object)template.getEntity());
    }

    @Test
    public void testFactory() {
        IMObject investigation = this.create("act.patientInvestigation");
        DocumentTemplateLocatorFactory factory = new DocumentTemplateLocatorFactory((ArchetypeService)this.getArchetypeService());
        DocumentTemplateLocator locator = factory.getDocumentTemplateLocator(investigation, (Context)new LocalContext());
        Assert.assertTrue((boolean)(locator instanceof InvestigationTemplateLocator));
    }
}

