/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.report;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.doc.TestDocumentTemplateBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.report.DocumentActTemplateLocator;
import org.openvpms.web.component.im.report.DocumentTemplateLocator;
import org.openvpms.web.component.im.report.DocumentTemplateLocatorFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DocumentActTemplateLocatorTestCase
extends ArchetypeServiceTest {
    @Autowired
    private TestDocumentFactory documentFactory;
    @Autowired
    private TestPatientFactory patientFactory;

    @Test
    public void testGetTemplate() {
        Entity entity = (Entity)((TestDocumentTemplateBuilder)this.documentFactory.newTemplate().type("act.patientDocumentForm").blankDocument()).build();
        DocumentAct act = (DocumentAct)this.patientFactory.newForm().template(entity).build(false);
        DocumentActTemplateLocator locator = new DocumentActTemplateLocator(act, (ArchetypeService)this.getArchetypeService());
        DocumentTemplate template = locator.getTemplate();
        Assert.assertNotNull((Object)template);
        Assert.assertEquals((Object)entity, (Object)template.getEntity());
    }

    @Test
    public void testFactory() {
        this.checkFactory("act.customerDocumentForm");
        this.checkFactory("act.customerDocumentLetter");
        this.checkFactory("act.patientDocumentForm");
        this.checkFactory("act.patientDocumentLetter");
        this.checkFactory("act.supplierDocumentForm");
        this.checkFactory("act.supplierDocumentLetter");
    }

    private void checkFactory(String archetype) {
        IMObject object = this.create(archetype);
        DocumentTemplateLocatorFactory factory = new DocumentTemplateLocatorFactory((ArchetypeService)this.getArchetypeService());
        DocumentTemplateLocator locator = factory.getDocumentTemplateLocator(object, (Context)new LocalContext());
        Assert.assertTrue((boolean)(locator instanceof DocumentActTemplateLocator));
    }
}

