/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.relationship;

import java.math.BigDecimal;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.service.archetype.helper.IMObjects;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.edit.AbstractCollectionPropertyEditorTest;
import org.openvpms.web.component.im.edit.CollectionPropertyEditor;
import org.openvpms.web.component.im.relationship.EntityLinkCollectionTargetPropertyEditor;
import org.openvpms.web.component.property.CollectionProperty;

public class EntityLinkCollectionTargetPropertyEditorTestCase
extends AbstractCollectionPropertyEditorTest {
    @Override
    protected IMObject createParent() {
        return TestHelper.createProduct();
    }

    @Override
    protected String getCollectionNode() {
        return "doses";
    }

    @Override
    protected CollectionPropertyEditor createEditor(CollectionProperty property, IMObject parent, IMObjects objects) {
        return new EntityLinkCollectionTargetPropertyEditor(property, (Entity)parent, objects);
    }

    @Override
    protected IMObject createObject(IMObject parent) {
        IMObject object = this.create("entity.productDose");
        IMObjectBean bean = this.getBean(object);
        bean.setValue("name", (Object)"Z Dose");
        bean.setValue("minWeight", (Object)BigDecimal.ZERO);
        bean.setValue("maxWeight", (Object)BigDecimal.TEN);
        bean.setValue("rate", (Object)BigDecimal.TEN);
        bean.setValue("roundTo", (Object)2);
        return object;
    }

    @Override
    protected void makeValid(IMObject object, boolean valid) {
        IMObjectBean bean = this.getBean(object);
        bean.setValue("minWeight", (Object)(valid ? BigDecimal.ZERO : null));
    }

    @Override
    protected void modify(IMObject object) {
        IMObjectBean bean = this.getBean(object);
        BigDecimal weight = bean.getBigDecimal("minWeight", BigDecimal.ZERO);
        bean.setValue("minWeight", (Object)weight.add(BigDecimal.ONE));
    }
}

