/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import java.util.Comparator;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.patient.PatientTestHelper;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.openvpms.web.component.im.query.PageLocator;
import org.openvpms.web.component.im.query.ParticipantConstraint;
import org.openvpms.web.component.im.query.QueryHelper;

public class QueryHelperTestCase
extends ArchetypeServiceTest {
    @Test
    public void testGetPage() {
        Party patient = TestHelper.createPatient();
        Act act1 = PatientTestHelper.createEvent((Date)TestHelper.getDate((String)"2014-07-01"), (Party)patient, (Act[])new Act[0]);
        Act act2 = PatientTestHelper.createEvent((Date)TestHelper.getDate((String)"2014-07-02"), (Party)patient, (Act[])new Act[0]);
        Act act3 = PatientTestHelper.createEvent((Date)TestHelper.getDate((String)"2014-07-03"), (Party)patient, (Act[])new Act[0]);
        Act act4 = PatientTestHelper.createEvent((Date)TestHelper.getDate((String)"2014-07-04"), (Party)patient, (Act[])new Act[0]);
        Act act5 = PatientTestHelper.createEvent((Date)TestHelper.getDate((String)"2014-07-05"), (Party)patient, (Act[])new Act[0]);
        ArchetypeQuery query1 = new ArchetypeQuery("act.patientClinicalEvent");
        query1.add((IConstraint)new ParticipantConstraint("patient", "participation.patient", (Entity)patient));
        this.checkPage(0, query1, act1, true);
        this.checkPage(0, query1, act2, true);
        this.checkPage(1, query1, act3, true);
        this.checkPage(1, query1, act4, true);
        this.checkPage(2, query1, act5, true);
        ArchetypeQuery query2 = new ArchetypeQuery("act.patientClinicalEvent");
        query2.add((IConstraint)new ParticipantConstraint("patient", "participation.patient", (Entity)patient));
        query2.add((IConstraint)new NodeSortConstraint("startTime", false));
        query2.add((IConstraint)new NodeSortConstraint("id"));
        this.checkPage(0, query2, act5, false);
        this.checkPage(0, query2, act4, false);
        this.checkPage(1, query2, act3, false);
        this.checkPage(1, query2, act2, false);
        this.checkPage(2, query2, act1, false);
    }

    private void checkPage(int expected, ArchetypeQuery query, Act act, boolean ascending) {
        int page = QueryHelper.getPage((IMObject)act, (ArchetypeQuery)query, (int)2, (String)"startTime", (boolean)ascending, (Comparator)PageLocator.DATE_COMPARATOR);
        Assert.assertEquals((long)expected, (long)page);
    }
}

