/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.component.business.domain.im.common.EntityIdentity;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.web.component.im.query.AbstractQueryTest;
import org.openvpms.web.component.im.query.Query;

public abstract class AbstractEntityQueryTest<T extends Entity>
extends AbstractQueryTest<T> {
    @Test
    public void testQueryById() {
        Entity entity = (Entity)this.createObject(true);
        Query query = this.createQuery();
        this.setValue(query, Long.toString(entity.getId()));
        List<Reference> matches = this.checkExists(entity, query, true);
        Assert.assertEquals((String)("Multiple entities match " + entity.getId()), (long)1L, (long)matches.size());
        Assert.assertEquals((long)1L, (long)query.query().getPages());
        this.remove((IMObject)entity);
        matches = this.checkExists(entity, query, false);
        Assert.assertEquals((long)0L, (long)matches.size());
        Assert.assertEquals((long)0L, (long)query.query().getPages());
    }

    @Test
    public void testQueryByIdentity() {
        String[] range;
        Entity entity = (Entity)this.createObject(true);
        IMObjectBean bean = this.getBean((IMObject)entity);
        if (bean.hasNode("identities") && (range = bean.getArchetypeRange("identities")).length != 0) {
            String shortName = range[0];
            EntityIdentity identity = (EntityIdentity)this.create(shortName, EntityIdentity.class);
            String value = "" + System.currentTimeMillis() + System.nanoTime();
            identity.setIdentity(value);
            entity.addIdentity((org.openvpms.component.model.entity.EntityIdentity)identity);
            Query query = this.createQuery();
            this.setValue(query, value);
            List<Reference> matches = this.checkExists(entity, query, false);
            Assert.assertEquals((long)0L, (long)matches.size());
            this.save((IMObject)entity);
            matches = this.checkExists(entity, query, true);
            Assert.assertEquals((long)1L, (long)matches.size());
            Assert.assertEquals((long)1L, (long)query.query().getPages());
            this.remove((IMObject)entity);
            matches = this.checkExists(entity, query, false);
            Assert.assertEquals((long)0L, (long)matches.size());
            Assert.assertEquals((long)0L, (long)query.query().getPages());
        }
    }
}

