/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.product;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.product.Product;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.IMObjectReferenceEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.product.ProductParticipationEditor;
import org.openvpms.web.component.im.product.ProductReferenceEditor;
import org.openvpms.web.component.im.query.ListQuery;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.select.AbstractQuerySelector;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;

public class ProductParticipationEditorTestCase
extends AbstractAppTest {
    @Test
    public void testReplaceProductWithinUpdateCallback() {
        Product template = TestHelper.createProduct((String)"product.template", null);
        final Product medication = TestHelper.createProduct((String)"product.medication", null);
        template.setName("Z Template");
        medication.setName("Z Medication");
        this.save((IMObject[])new Product[]{template, medication});
        Participation participation = (Participation)this.create("participation.product", Participation.class);
        Act parent = (Act)this.create("act.patientMedication", Act.class);
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        final ProductParticipationEditor editor = new ProductParticipationEditor(participation, parent, (LayoutContext)context){

            protected IMObjectReferenceEditor<Product> createEntityEditor(Property property) {
                return new TestReferenceEditor(this, property, this.getLayoutContext());
            }
        };
        editor.getComponent();
        TestReferenceEditor productEditor = (TestReferenceEditor)editor.getEditor();
        Assert.assertNotNull((Object)editor);
        productEditor.setQueryObjects(template);
        editor.addModifiableListener(new ModifiableListener(){

            public void modified(Modifiable modifiable) {
                editor.setEntity((Entity)medication);
            }
        });
        productEditor.getSelector().getTextField().setText(template.getName());
        Assert.assertEquals((Object)medication, (Object)editor.getEntity());
        Assert.assertEquals((Object)medication.getName(), (Object)productEditor.getSelector().getText());
    }

    private class TestReferenceEditor
    extends ProductReferenceEditor {
        private List<Product> queryObjects;

        public TestReferenceEditor(ProductParticipationEditor editor, Property property, LayoutContext context) {
            super(editor, property, context);
            this.queryObjects = new ArrayList<Product>();
        }

        public void setQueryObjects(Product ... objects) {
            this.queryObjects = Arrays.asList(objects);
        }

        public AbstractQuerySelector<Product> getSelector() {
            return super.getSelector();
        }

        protected Query<Product> createQuery(String name) {
            return new ListQuery(this.queryObjects, "product.*", Product.class);
        }
    }
}

