/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.lookup;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.workflow.ScheduleArchetypes;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.EditorTestHelper;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.lookup.SelectorLookupPropertyEditor;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.select.AbstractQuerySelector;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.text.TextField;
import org.openvpms.web.test.AbstractAppTest;

public class SelectorLookupPropertyEditorTestCase
extends AbstractAppTest {
    private TestEditor editor;
    private SimpleProperty property;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        Act object = (Act)this.create("act.patientClinicalEvent", Act.class);
        object.setReason(null);
        this.property = new SimpleProperty("reason", String.class);
        this.property.setRequired(true);
        this.editor = new TestEditor(ScheduleArchetypes.VISIT_REASON, (Property)this.property, (IMObject)object, (LayoutContext)new DefaultLayoutContext(true, (Context)new LocalContext(), new HelpContext("foo", null)));
    }

    @Test
    public void testSetTextForOneMatch() {
        Lookup lookup1 = this.createLookup("Checkup");
        Lookup lookup2 = this.createLookup("Surgery");
        this.editor.setQueryObjects(lookup1, lookup2);
        TextField textField = this.editor.getSelector().getTextField();
        Assert.assertNull((Object)this.editor.getObject());
        Assert.assertFalse((boolean)this.editor.isModified());
        Assert.assertNull((Object)this.property.getString());
        Assert.assertFalse((boolean)this.editor.isValid());
        this.checkSet("Ch", lookup1);
        textField.setText("Ch");
        this.checkSet(null, null);
        this.checkSet("eck", lookup1);
    }

    @Test
    public void testSetTextForTwoMatches() {
        Lookup lookup1 = this.createLookup("Day surgery");
        Lookup lookup2 = this.createLookup("Overnight surgery");
        this.editor.setQueryObjects(lookup1, lookup2);
        this.editor.setSelection(lookup2);
        this.checkSet("surgery", lookup2);
        this.editor.setSelection(lookup1);
        this.checkSet("surg", lookup1);
    }

    @Test
    public void testWildcards() {
        Lookup lookup1 = this.createLookup("Checkup");
        Lookup lookup2 = this.createLookup("Surgery");
        Lookup lookup3 = this.createLookup("Vaccination");
        this.editor.setQueryObjects(lookup1, lookup2, lookup3);
        this.checkSet("ch*", lookup1);
        this.checkSet("*urge*", lookup2);
        this.checkSet("*up", lookup1);
    }

    @Test
    public void testNoMatch() {
        Lookup lookup1 = this.createLookup("Vaccination");
        Lookup lookup2 = this.createLookup("Checkup");
        this.editor.setQueryObjects(lookup1, lookup2);
        this.checkSet("vacc", lookup1);
        TextField field = this.editor.getSelector().getTextField();
        field.setText("*vax*");
        Assert.assertEquals((Object)"*vax*", (Object)field.getText());
        Assert.assertTrue((boolean)this.editor.isModified());
        Assert.assertEquals((Object)lookup1, (Object)this.editor.getObject());
        Assert.assertEquals((Object)lookup1.getCode(), (Object)this.property.getString());
        EditorTestHelper.assertInvalid((Modifiable)this.editor, "*vax* is not a valid value for Reason");
        this.checkSet("*vac*", lookup1);
    }

    private void checkSet(String text, Lookup expected) {
        TextField field = this.editor.getSelector().getTextField();
        field.setText(text);
        if (expected != null) {
            Assert.assertEquals((Object)expected.getName(), (Object)field.getText());
            Assert.assertEquals((Object)expected, (Object)this.editor.getObject());
            Assert.assertTrue((boolean)this.editor.isModified());
            Assert.assertEquals((Object)expected.getCode(), (Object)this.property.getString());
            Assert.assertTrue((boolean)this.editor.isValid());
        } else {
            Assert.assertNull((Object)this.editor.getObject());
            Assert.assertFalse((boolean)this.editor.isValid());
            Assert.assertNull((Object)this.property.getString());
        }
    }

    private Lookup createLookup(String name) {
        Lookup lookup = (Lookup)this.create(ScheduleArchetypes.VISIT_REASON, Lookup.class);
        lookup.setCode(name.toUpperCase());
        lookup.setName(name);
        return lookup;
    }

    private static class TestEditor
    extends SelectorLookupPropertyEditor {
        private List<Lookup> lookups = Collections.emptyList();
        private Lookup selection;

        public TestEditor(String archetype, Property property, IMObject parent, LayoutContext context) {
            super(archetype, property, parent, context);
        }

        public void setQueryObjects(Lookup ... lookups) {
            this.lookups = Arrays.asList(lookups);
        }

        public void setSelection(Lookup selection) {
            this.selection = selection;
        }

        public AbstractQuerySelector<Lookup> getSelector() {
            return super.getSelector();
        }

        public Lookup getObject() {
            if (this.lookups != null) {
                String code = this.getProperty().getString();
                return this.lookups.stream().filter(l -> l.getCode().equals(code)).findFirst().orElse(null);
            }
            return null;
        }

        protected List<Lookup> getLookups(Property property) {
            return this.lookups;
        }

        protected AbstractQuerySelector<Lookup> createSelector(Property property, LayoutContext context, boolean allowCreate) {
            return new TestLookupSelector(property, allowCreate, context);
        }

        private class TestLookupSelector
        extends SelectorLookupPropertyEditor.LookupSelector {
            public TestLookupSelector(Property property, boolean allowCreate, LayoutContext context) {
                super((SelectorLookupPropertyEditor)TestEditor.this, property, allowCreate, context);
            }

            protected void onSelect(boolean runQuery) {
                Assert.assertNotNull((String)"selection cannot be null", (Object)TestEditor.this.selection);
                Browser browser = this.createBrowser(this.getText(), runQuery);
                this.onSelected(TestEditor.this.selection, browser);
            }
        }
    }
}

