/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.im.lookup.NodeLookupQuery;
import org.openvpms.web.test.AbstractAppTest;

public class NodeLookupQueryTestCase
extends AbstractAppTest {
    @Test
    public void testGetLookupsForNodeName() {
        NodeLookupQuery query = new NodeLookupQuery("party.customerperson", "title");
        this.checkTitles(query);
    }

    @Test
    public void testGetLookupsForDescriptor() {
        Party customer = TestHelper.createCustomer((boolean)false);
        ArchetypeDescriptor archetype = this.getArchetypeService().getArchetypeDescriptor(customer.getArchetype());
        NodeDescriptor descriptor = archetype.getNodeDescriptor("title");
        Assert.assertNotNull((Object)descriptor);
        NodeLookupQuery query = new NodeLookupQuery((IMObject)customer, (org.openvpms.component.model.archetype.NodeDescriptor)descriptor);
        this.checkTitles(query);
    }

    @Test
    public void testInactiveLookups() {
        Party patient = TestHelper.createPatient((boolean)false);
        IMObjectBean bean = this.getBean((IMObject)patient);
        Lookup canine = TestHelper.getLookup((String)"lookup.species", (String)"CANINE");
        Lookup canineBreed = TestHelper.getLookup((String)"lookup.breed", (String)"BLOODHOUND", (Lookup)canine, (String)"lookupRelationship.speciesBreed");
        Lookup feline = TestHelper.getLookup((String)"lookup.species", (String)"FELINE");
        Lookup felineBreed = TestHelper.getLookup((String)"lookup.breed", (String)"ABYSSINIAN", (Lookup)feline, (String)"lookupRelationship.speciesBreed");
        bean.setValue("species", (Object)canine.getCode());
        bean.setValue("breed", (Object)canineBreed.getCode());
        NodeLookupQuery speciesQuery = new NodeLookupQuery((IMObject)patient, bean.getNode("species"));
        this.checkLookups(speciesQuery, true, canine, feline);
        NodeLookupQuery breedQuery = new NodeLookupQuery((IMObject)patient, bean.getNode("breed"));
        this.checkLookups(breedQuery, true, canineBreed);
        this.checkLookups(breedQuery, false, felineBreed);
        canine.setActive(false);
        this.save((IMObject)canine);
        this.checkLookups(speciesQuery, true, canine, feline);
        this.checkLookups(breedQuery, true, canineBreed);
        this.checkLookups(breedQuery, false, felineBreed);
        canineBreed.setActive(false);
        this.save((IMObject)canineBreed);
        this.checkLookups(speciesQuery, true, canine, feline);
        this.checkLookups(breedQuery, true, canineBreed);
        this.checkLookups(breedQuery, false, felineBreed);
        bean.setValue("species", (Object)feline.getCode());
        bean.setValue("breed", (Object)felineBreed.getCode());
        this.checkLookups(speciesQuery, true, feline);
        this.checkLookups(speciesQuery, false, canine);
        this.checkLookups(breedQuery, true, felineBreed);
        this.checkLookups(breedQuery, false, canineBreed);
    }

    private void checkTitles(NodeLookupQuery query) {
        Collection titles = this.getLookupService().getLookups("lookup.personTitle");
        ArrayList<Lookup> expected = new ArrayList<Lookup>();
        for (Lookup title : titles) {
            if (!title.isActive()) continue;
            expected.add(title);
        }
        List actual = query.getLookups();
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        for (Lookup l : expected) {
            Assert.assertTrue((boolean)actual.contains(l));
        }
    }

    private void checkLookups(NodeLookupQuery query, boolean exists, Lookup ... lookups) {
        List actual = query.getLookups();
        for (Lookup lookup : lookups) {
            Assert.assertEquals((Object)exists, (Object)actual.contains(lookup));
        }
    }
}

