/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.component.business.service.archetype.helper.IMObjects;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.edit.AbstractCollectionPropertyEditorTest;
import org.openvpms.web.component.im.edit.CollectionPropertyEditor;
import org.openvpms.web.component.im.edit.DefaultCollectionPropertyEditor;
import org.openvpms.web.component.property.CollectionProperty;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultCollectionPropertyEditorTestCase
extends AbstractCollectionPropertyEditorTest {
    @Autowired
    private TestCustomerFactory customerFactory;

    @Test
    public void testGetArchetypeRange() {
        IMObject parent = this.createParent();
        CollectionProperty property = this.getCollectionProperty(parent);
        CollectionPropertyEditor editor = this.createEditor(property, parent, this.getObjects());
        String[] range = editor.getArchetypeRange();
        Assert.assertEquals((long)4L, (long)range.length);
        HashSet<String> set = new HashSet<String>(Arrays.asList(range));
        Assert.assertTrue((boolean)set.contains("contact.location"));
        Assert.assertTrue((boolean)set.contains("contact.phoneNumber"));
        Assert.assertTrue((boolean)set.contains("contact.email"));
        Assert.assertTrue((boolean)set.contains("contact.website"));
    }

    @Override
    protected IMObject createParent() {
        return this.customerFactory.newCustomer().name("foo", "xyz").build(false);
    }

    @Override
    protected String getCollectionNode() {
        return "contacts";
    }

    @Override
    protected CollectionPropertyEditor createEditor(CollectionProperty property, IMObject parent, IMObjects objects) {
        return new DefaultCollectionPropertyEditor(property);
    }

    @Override
    protected IMObject createObject(IMObject parent) {
        return this.create("contact.location");
    }

    @Override
    protected void makeValid(IMObject object, boolean valid) {
        IMObjectBean bean = this.getBean(object);
        bean.setValue("startDate", (Object)(valid ? new Date() : null));
    }

    @Override
    protected void modify(IMObject object) {
        IMObjectBean bean = this.getBean(object);
        Date date = bean.getDate("startDate", new Date());
        bean.setValue("startDate", (Object)DateRules.getDate((Date)date, (int)1, (DateUnits)DateUnits.DAYS));
    }
}

