/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditorFactory;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractIMObjectEditorTest<T extends IMObjectEditor>
extends AbstractAppTest {
    private final Class<T> type;
    private final String archetype;
    @Autowired
    private IMObjectEditorFactory factory;

    public AbstractIMObjectEditorTest(Class<T> type, String archetype) {
        this.type = type;
        this.archetype = archetype;
    }

    @Test
    public void testNewInstance() {
        this.checkNewInstance(this.archetype, this.type);
    }

    @Test
    public void testFactory() {
        this.checkFactory(this.archetype, this.type);
    }

    protected void checkFactory(String archetype, Class<T> type) {
        IMObject object = this.create(archetype);
        LayoutContext context = this.createLayoutContext();
        IMObjectEditor editor = this.factory.create(object, context);
        Assert.assertEquals(type, editor.getClass());
    }

    protected IMObjectEditor createEditor(IMObject object) {
        LayoutContext context = this.createLayoutContext();
        return this.createEditor(object, context);
    }

    protected LayoutContext createLayoutContext() {
        return this.createLayoutContext((Context)new LocalContext());
    }

    protected LayoutContext createLayoutContext(Context context) {
        DefaultLayoutContext result = new DefaultLayoutContext(context, new HelpContext("foo", null));
        result.setEdit(true);
        return result;
    }

    protected T newEditor(IMObject object) {
        return (T)((IMObjectEditor)this.type.cast(this.createEditor(object)));
    }

    protected T newEditor(IMObject object, Context context) {
        return (T)((IMObjectEditor)this.type.cast(this.createEditor(object, this.createLayoutContext(context))));
    }

    protected IMObjectEditor createEditor(IMObject object, LayoutContext context) {
        return this.factory.create(object, context);
    }

    protected IMObject newObject() {
        return this.create(this.archetype);
    }

    protected void checkNewInstance(String archetype, Class<T> type) {
        IMObject object = this.create(archetype);
        IMObjectEditor editor = this.createEditor(object);
        Assert.assertEquals(type, editor.getClass());
        IMObjectEditor newInstance = editor.newInstance();
        Assert.assertNotNull((Object)newInstance);
        Assert.assertNotEquals((Object)editor, (Object)newInstance);
        Assert.assertEquals(type, newInstance.getClass());
    }

    protected IMObjectEditorFactory getFactory() {
        return this.factory;
    }
}

