/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.doc;

import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.doc.TestDocumentTemplateBuilder;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.web.component.im.doc.DocumentActEditor;
import org.openvpms.web.component.im.edit.AbstractIMObjectEditorTest;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.system.ServiceHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class AbstractDocumentActEditorTest<T extends DocumentActEditor>
extends AbstractIMObjectEditorTest<T> {
    @Autowired
    private TestDocumentFactory documentFactory;

    public AbstractDocumentActEditorTest(Class<T> type, String archetype) {
        super(type, archetype);
    }

    protected DocumentAct createAct() {
        return (DocumentAct)this.newObject();
    }

    protected abstract DocumentActEditor createEditor(DocumentAct var1);

    protected boolean save(DocumentActEditor editor) {
        return SaveHelper.save((IMObjectEditor)editor);
    }

    protected void delete(final DocumentActEditor editor) {
        TransactionTemplate txn = new TransactionTemplate(ServiceHelper.getTransactionManager());
        txn.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
                editor.delete();
            }
        });
    }

    protected Document createImage() {
        String name = "/org/openvpms/web/resource/image/openvpms.png";
        return this.createDocument(name);
    }

    protected Document createDocument(String path) {
        return (Document)this.documentFactory.createDocument(path);
    }

    protected Entity createDocumentTemplate(String archetype) {
        return (Entity)((TestDocumentTemplateBuilder)((TestDocumentTemplateBuilder)this.documentFactory.newTemplate().type(archetype).blankDocument()).name("blank")).build();
    }
}

